/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.embedded;

import java.io.File;
import org.jboss.as.embedded.SecurityActions;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;

final class InitialModuleLoaderFactory {
    private InitialModuleLoaderFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleLoader getModuleLoader(File modulePath, String ... systemPackages) {
        if (modulePath == null || !modulePath.isDirectory()) {
            throw new IllegalArgumentException("Invalid module path: " + modulePath);
        }
        String oldClassPath = SecurityActions.getSystemProperty("java.class.path");
        try {
            ModuleLoader moduleLoader;
            SecurityActions.clearSystemProperty("java.class.path");
            SecurityActions.setSystemProperty("module.path", modulePath.getAbsolutePath());
            StringBuffer packages = new StringBuffer("org.jboss.modules," + InitialModuleLoaderFactory.class.getPackage().getName());
            if (systemPackages != null) {
                for (String packageName : systemPackages) {
                    packages.append("," + packageName);
                }
            }
            SecurityActions.setSystemProperty("jboss.modules.system.pkgs", packages.toString());
            ModuleLoader moduleLoader2 = moduleLoader = Module.getBootModuleLoader();
            return moduleLoader2;
        }
        finally {
            SecurityActions.setSystemProperty("java.class.path", oldClassPath);
        }
    }
}

