/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.host.controller.descriptions.HostServerDescription;
import org.jboss.dmr.ModelNode;

public class ServerAddHandler
implements ModelAddOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "add";
    public static final ServerAddHandler INSTANCE = new ServerAddHandler();

    public static ModelNode getAddServerOperation(ModelNode address, ModelNode name, ModelNode group) {
        ModelNode op = Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
        op.get("name").set(name);
        op.get("group").set(group);
        return op;
    }

    ServerAddHandler() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        try {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String name = address.getLastElement().getValue();
            ModelNode model = context.getSubModel();
            this.createCoreModel(model);
            model.get("name").set(name);
            model.get("group").set(operation.require("group"));
            if (operation.hasDefined("socket-binding-group")) {
                model.get("socket-binding-group").set(operation.get("socket-binding-group"));
            }
            if (operation.hasDefined("socket-binding-port-offset")) {
                model.get("socket-binding-port-offset").set(operation.get("socket-binding-port-offset"));
            }
            ModelNode compensating = Util.getResourceRemoveOperation((ModelNode)operation.get("address"));
            resultHandler.handleResultComplete();
            return new BasicOperationResult(compensating);
        }
        catch (Exception e) {
            throw new OperationFailedException(new ModelNode().set(e.getLocalizedMessage()));
        }
    }

    private void createCoreModel(ModelNode root) {
        root.get("path");
        root.get("system-property");
        root.get("interface");
        root.get("jvm");
    }

    public ModelNode getModelDescription(Locale locale) {
        return HostServerDescription.getServerAddOperation(locale);
    }
}

