/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.NoSuchElementException;
import java.util.concurrent.ScheduledExecutorService;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.persistence.ConfigurationFile;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.DomainControllerService;
import org.jboss.as.domain.controller.DomainDeploymentRepository;
import org.jboss.as.domain.controller.DomainModelImpl;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.as.domain.controller.HostRegistryService;
import org.jboss.as.domain.controller.LocalHostModel;
import org.jboss.as.domain.controller.MasterDomainControllerClient;
import org.jboss.as.host.controller.ConfigurationPersisterFactory;
import org.jboss.as.host.controller.HostController;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.RemoteDomainConnectionService;
import org.jboss.as.host.controller.mgmt.DomainControllerOperationHandlerService;
import org.jboss.as.host.controller.mgmt.ManagementCommunicationService;
import org.jboss.as.server.deployment.api.DeploymentRepository;
import org.jboss.as.server.services.net.NetworkInterfaceBinding;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class DomainControllerAddUtil {
    static final ServiceName HOST_CONTROLLER_SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"host", "controller"});

    static void installLocalDomainController(HostControllerEnvironment environment, ModelNode host, ServiceTarget serviceTarget, boolean isSlave, FileRepository fileRepository, DomainModelImpl domainModel) {
        String hostName = host.get("name").asString();
        String mgmtNetwork = host.get(new String[]{"management-interfaces", "native-interface", "interface"}).asString();
        int mgmtPort = host.get(new String[]{"management-interfaces", "native-interface", "port"}).asInt();
        boolean backupDomainFiles = environment.isBackupDomainFiles();
        boolean useCachedDc = environment.isUseCachedDc();
        serviceTarget.addService(HostRegistryService.SERVICE_NAME, (Service)new HostRegistryService()).install();
        File configDir = environment.getDomainConfigurationDir();
        ConfigurationFile configurationFile = environment.getDomainConfigurationFile();
        ExtensibleConfigurationPersister domainConfigurationPersister = DomainControllerAddUtil.createDomainConfigurationPersister(configDir, configurationFile, isSlave);
        DomainDeploymentRepository deploymentRepository = new DomainDeploymentRepository(environment.getDomainDeploymentDir());
        DomainControllerService dcService = new DomainControllerService(domainConfigurationPersister, hostName, mgmtPort, (DeploymentRepository)deploymentRepository, fileRepository, backupDomainFiles, useCachedDc, domainModel);
        ServiceBuilder builder = serviceTarget.addService(DomainController.SERVICE_NAME, (Service)dcService);
        if (isSlave) {
            builder.addDependency(MasterDomainControllerClient.SERVICE_NAME, MasterDomainControllerClient.class, dcService.getMasterDomainControllerClientInjector());
        }
        builder.addDependency(HOST_CONTROLLER_SERVICE_NAME_BASE.append(new String[]{"executor"}), ScheduledExecutorService.class, dcService.getScheduledExecutorServiceInjector()).addDependency(HostController.SERVICE_NAME, LocalHostModel.class, dcService.getHostControllerServiceInjector()).addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{mgmtNetwork}), NetworkInterfaceBinding.class, dcService.getInterfaceInjector()).addDependency(HostRegistryService.SERVICE_NAME, HostRegistryService.class, (Injector)dcService.getHostRegistryInjector()).install();
        DomainControllerOperationHandlerService operationHandlerService = new DomainControllerOperationHandlerService(isSlave);
        serviceTarget.addService(DomainControllerOperationHandlerService.SERVICE_NAME, (Service)operationHandlerService).addDependency(ManagementCommunicationService.SERVICE_NAME, ManagementCommunicationService.class, operationHandlerService.getManagementCommunicationServiceValue()).addDependency(DomainController.SERVICE_NAME, ModelController.class, (Injector)operationHandlerService.getModelControllerValue()).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    static void installRemoteDomainControllerConnection(ModelNode host, ServiceTarget serviceTarget, FileRepository repository) {
        InetAddress addr;
        String name;
        try {
            name = host.require("name").asString();
        }
        catch (NoSuchElementException e1) {
            throw new IllegalArgumentException("A host connecting to a remote domain controller must have its name attribute set");
        }
        ModelNode dc = host.require("domain-controller").require("remote");
        try {
            addr = InetAddress.getByName(dc.require("host").asString());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        int port = dc.require("port").asInt();
        RemoteDomainConnectionService service = new RemoteDomainConnectionService(name, addr, port, repository);
        serviceTarget.addService(MasterDomainControllerClient.SERVICE_NAME, (Service)service).addDependency(ManagementCommunicationService.SERVICE_NAME, ManagementCommunicationService.class, service.getManagementCommunicationServiceInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    static ExtensibleConfigurationPersister createDomainConfigurationPersister(File configDir, ConfigurationFile configurationFile, boolean isSlave) {
        if (isSlave) {
            return ConfigurationPersisterFactory.createCachedRemoteDomainXmlConfigurationPersister(configDir);
        }
        return ConfigurationPersisterFactory.createDomainXmlConfigurationPersister(configDir, configurationFile);
    }
}

