/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.host.controller.DomainModelProxy;
import org.jboss.as.host.controller.HostModelUtil;
import org.jboss.dmr.ModelNode;

public class LocalHostAddHandler
implements ModelAddOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "add-host";
    private final ModelNodeRegistration registration;
    private final DomainModelProxy domainModelProxy;

    public static LocalHostAddHandler getInstance(ModelNodeRegistration registration, DomainModelProxy domainModelProxy) {
        return new LocalHostAddHandler(registration, domainModelProxy);
    }

    private LocalHostAddHandler(ModelNodeRegistration registration, DomainModelProxy domainModelProxy) {
        this.registration = registration;
        this.domainModelProxy = domainModelProxy;
    }

    public ModelNode getModelDescription(Locale locale) {
        return new ModelNode();
    }

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        try {
            ModelNode model = context.getSubModel();
            HostModelUtil.initCoreModel(model);
            String hostName = operation.require("name").asString();
            model.get("name").set(hostName);
            if (context.getRuntimeContext() != null) {
                this.domainModelProxy.getDomainModel().setLocalHostName(hostName);
            }
            context.getRegistry().registerSubModel(PathElement.pathElement((String)"host", (String)hostName), this.registration);
            ModelNode compensating = Util.getResourceRemoveOperation((ModelNode)operation.get("address"));
            resultHandler.handleResultComplete();
            return new BasicOperationResult(compensating);
        }
        catch (Exception e) {
            throw new OperationFailedException(new ModelNode().set(e.getLocalizedMessage()));
        }
    }
}

