/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.ManagementDescription;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.dmr.ModelNode;

public class HttpManagementAddHandler
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final String OPERATION_NAME = "add";
    private final LocalHostControllerInfoImpl hostControllerInfo;

    private HttpManagementAddHandler(LocalHostControllerInfoImpl hostControllerInfo) {
        this.hostControllerInfo = hostControllerInfo;
    }

    public static HttpManagementAddHandler getInstance(LocalHostControllerInfoImpl hostControllerInfo) {
        return new HttpManagementAddHandler(hostControllerInfo);
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        String interfaceName = operation.require("interface").asString();
        int port = this.getIntValue(operation, "port");
        int securePort = this.getIntValue(operation, "secure-port");
        String securityRealm = operation.hasDefined("security-realm") ? operation.get("security-realm").asString() : null;
        model.get("interface").set(interfaceName);
        if (port > -1) {
            model.get("port").set(port);
        }
        if (securePort > -1) {
            model.get("secure-port").set(securePort);
        }
        if (securityRealm != null) {
            model.get("security-realm").set(securityRealm);
        }
        this.hostControllerInfo.setHttpManagementInterface(interfaceName);
        this.hostControllerInfo.setHttpManagementPort(port);
        this.hostControllerInfo.setHttpManagementSecurePort(securePort);
        this.hostControllerInfo.setHttpManagementSecurityRealm(securityRealm);
    }

    public ModelNode getModelDescription(Locale locale) {
        return ManagementDescription.getAddHttpManagementDescription((Locale)locale);
    }

    private int getIntValue(ModelNode source, String name) {
        if (source.has(name)) {
            return source.require(name).asInt();
        }
        return -1;
    }
}

