/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.File;
import java.util.concurrent.ExecutorService;
import javax.xml.namespace.QName;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.persistence.BackupXmlConfigurationPersister;
import org.jboss.as.controller.persistence.ConfigurationFile;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.persistence.NullConfigurationPersister;
import org.jboss.as.controller.persistence.XmlConfigurationPersister;
import org.jboss.as.host.controller.parsing.DomainXml;
import org.jboss.as.host.controller.parsing.HostXml;
import org.jboss.modules.Module;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class ConfigurationPersisterFactory {
    public static ExtensibleConfigurationPersister createHostXmlConfigurationPersister(File configDir, ConfigurationFile file, ExecutorService executorService) {
        HostXml hostXml = new HostXml(Module.getBootModuleLoader(), executorService);
        BackupXmlConfigurationPersister persister = new BackupXmlConfigurationPersister(file, new QName(Namespace.CURRENT.getUriString(), "host"), (XMLElementReader)hostXml, (XMLElementWriter)hostXml);
        persister.registerAdditionalRootElement(new QName(Namespace.DOMAIN_1_0.getUriString(), "host"), (XMLElementReader)hostXml);
        return persister;
    }

    public static ExtensibleConfigurationPersister createDomainXmlConfigurationPersister(File configDir, ConfigurationFile file, ExecutorService executorService) {
        DomainXml domainXml = new DomainXml(Module.getBootModuleLoader(), executorService);
        BackupXmlConfigurationPersister persister = new BackupXmlConfigurationPersister(file, new QName(Namespace.CURRENT.getUriString(), "domain"), (XMLElementReader)domainXml, (XMLElementWriter)domainXml);
        persister.registerAdditionalRootElement(new QName(Namespace.DOMAIN_1_0.getUriString(), "domain"), (XMLElementReader)domainXml);
        return persister;
    }

    public static ExtensibleConfigurationPersister createCachedRemoteDomainXmlConfigurationPersister(File configDir, ExecutorService executorService) {
        DomainXml domainXml = new DomainXml(Module.getBootModuleLoader(), executorService);
        File file = new File(configDir, "domain.cached-remote.xml");
        return new XmlConfigurationPersister(file, new QName(Namespace.CURRENT.getUriString(), "domain"), (XMLElementReader)domainXml, (XMLElementWriter)domainXml);
    }

    public static ExtensibleConfigurationPersister createTransientDomainXmlConfigurationPersister(ExecutorService executorService) {
        DomainXml domainXml = new DomainXml(Module.getBootModuleLoader(), executorService);
        return new NullConfigurationPersister((XMLElementWriter)domainXml);
    }
}

