/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.host.controller.operations.NativeManagementAddHandler;
import org.jboss.as.host.controller.resources.NativeManagementResourceDefinition;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.dmr.ModelNode;

public class NativeManagementWriteAttributeHandler
extends AbstractWriteAttributeHandler<Void> {
    private final LocalHostControllerInfoImpl hostControllerInfo;

    public NativeManagementWriteAttributeHandler(LocalHostControllerInfoImpl hostControllerInfo) {
        super(NativeManagementResourceDefinition.ATTRIBUTE_DEFINITIONS);
        this.hostControllerInfo = hostControllerInfo;
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ModelNode subModel = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
        context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
        this.installNativeManagementService(context, subModel, verificationHandler);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode subModel = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        subModel.get(attributeName).set(valueToRestore);
        this.installNativeManagementService(context, subModel, null);
    }

    private void installNativeManagementService(OperationContext context, ModelNode subModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        ModelNode portNode = NativeManagementResourceDefinition.NATIVE_PORT.resolveModelAttribute(context, subModel);
        int port = portNode.isDefined() ? portNode.asInt() : 0;
        ManagementRemotingServices.removeConnectorServices((OperationContext)context, (String)"management");
        NativeManagementAddHandler.populateHostControllerInfo(this.hostControllerInfo, context, subModel);
        NativeManagementAddHandler.installNativeManagementServices(context.getServiceTarget(), this.hostControllerInfo, verificationHandler, null);
    }
}

