/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.net.InetSocketAddress;
import java.util.concurrent.Future;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.ProcessControllerConnectionService;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.ServerInventoryCallbackService;
import org.jboss.as.host.controller.ServerInventoryImpl;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.AsyncFutureTask;

class ServerInventoryService
implements Service<ServerInventory> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.host.controller");
    static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"host", "controller", "server-inventory"});
    private final InjectedValue<ProcessControllerConnectionService> client = new InjectedValue();
    private final InjectedValue<NetworkInterfaceBinding> interfaceBinding = new InjectedValue();
    private final DomainController domainController;
    private final HostControllerEnvironment environment;
    private final int port;
    private final FutureServerInventory futureInventory = new FutureServerInventory();
    private ServerInventory serverInventory;

    private ServerInventoryService(DomainController domainController, HostControllerEnvironment environment, int port) {
        this.domainController = domainController;
        this.environment = environment;
        this.port = port;
    }

    static Future<ServerInventory> install(ServiceTarget serviceTarget, DomainController domainController, HostControllerEnvironment environment, String interfaceBinding, int port) {
        ServerInventoryCallbackService callbackService = new ServerInventoryCallbackService();
        serviceTarget.addService(ServerInventoryCallbackService.SERVICE_NAME, (Service)callbackService).addDependency(SERVICE_NAME, ServerInventory.class, callbackService.getServerInventoryInjectedValue()).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        ServerInventoryService inventory = new ServerInventoryService(domainController, environment, port);
        serviceTarget.addService(SERVICE_NAME, (Service)inventory).addDependency(ProcessControllerConnectionService.SERVICE_NAME, ProcessControllerConnectionService.class, inventory.getClient()).addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{interfaceBinding}), NetworkInterfaceBinding.class, inventory.interfaceBinding).install();
        return inventory.futureInventory;
    }

    public synchronized void start(StartContext context) throws StartException {
        log.debug((Object)"Starting Host Controller Server Inventory");
        try {
            ProcessControllerConnectionService processControllerConnectionService = (ProcessControllerConnectionService)this.client.getValue();
            InetSocketAddress binding = new InetSocketAddress(((NetworkInterfaceBinding)this.interfaceBinding.getValue()).getAddress(), this.port);
            this.serverInventory = new ServerInventoryImpl(this.domainController, this.environment, binding, processControllerConnectionService.getClient());
            processControllerConnectionService.setServerInventory(this.serverInventory);
            this.futureInventory.setInventory(this.serverInventory);
        }
        catch (Exception e) {
            this.futureInventory.setFailure(e);
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        this.serverInventory.stopServers(-1);
        this.serverInventory = null;
        ((ProcessControllerConnectionService)this.client.getValue()).setServerInventory(null);
    }

    public synchronized ServerInventory getValue() throws IllegalStateException, IllegalArgumentException {
        ServerInventory serverInventory = this.serverInventory;
        if (serverInventory == null) {
            throw new IllegalStateException();
        }
        return serverInventory;
    }

    InjectedValue<ProcessControllerConnectionService> getClient() {
        return this.client;
    }

    private class FutureServerInventory
    extends AsyncFutureTask<ServerInventory> {
        protected FutureServerInventory() {
            super(null);
        }

        private void setInventory(ServerInventory inventory) {
            super.setResult((Object)inventory);
        }

        private void setFailure(Throwable t) {
            super.setFailed(t);
        }
    }
}

