/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.remote.ExistingChannelModelControllerClient;
import org.jboss.as.controller.remote.TransactionalModelControllerOperationHandler;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.as.domain.controller.SlaveRegistrationException;
import org.jboss.as.domain.management.CallbackHandlerFactory;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.host.controller.HostControllerLogger;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.MasterDomainControllerClient;
import org.jboss.as.host.controller.ReconnectPolicy;
import org.jboss.as.process.protocol.Connection;
import org.jboss.as.process.protocol.ProtocolUtils;
import org.jboss.as.protocol.ProtocolChannelClient;
import org.jboss.as.protocol.mgmt.AbstractManagementRequest;
import org.jboss.as.protocol.mgmt.AbstractMessageHandler;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelReceiver;
import org.jboss.as.protocol.mgmt.ManagementMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.jboss.threads.AsyncFuture;
import org.jboss.threads.AsyncFutureTask;
import org.jboss.threads.JBossThreadFactory;
import org.xnio.OptionMap;

public class RemoteDomainConnectionService
implements MasterDomainControllerClient,
Service<MasterDomainControllerClient>,
Connection.ClosedCallback {
    private final ModelController controller;
    private final InetAddress host;
    private final int port;
    private final String name;
    private final RemoteFileRepository remoteFileRepository;
    private volatile ProtocolChannelClient channelClient;
    private volatile ModelControllerClient masterProxy;
    private final AtomicBoolean shutdown = new AtomicBoolean();
    private volatile Channel channel;
    private volatile AbstractMessageHandler handler;
    private final ThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("domain-connection-threads"), Boolean.FALSE, null, "%G - %t", null, null, AccessController.getContext());
    private final ExecutorService executor = Executors.newCachedThreadPool(this.threadFactory);
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private final AtomicBoolean registered = new AtomicBoolean(false);
    private final FutureClient futureClient = new FutureClient();
    private final InjectedValue<Endpoint> endpointInjector = new InjectedValue();
    private final InjectedValue<CallbackHandlerFactory> callbackFactoryInjector = new InjectedValue();
    private RemoteFileRepositoryExecutor remoteFileRepositoryExecutor = new RemoteFileRepositoryExecutor(){

        @Override
        public File getFile(String relativePath, byte repoId, FileRepository localFileRepository) {
            try {
                return (File)new GetFileRequest(repoId, relativePath, localFileRepository).executeForResult(RemoteDomainConnectionService.this.handler, RemoteDomainConnectionService.this.channel, null);
            }
            catch (Exception e) {
                throw HostControllerMessages.MESSAGES.failedToGetFileFromRemoteRepository(e);
            }
        }
    };

    private RemoteDomainConnectionService(ModelController controller, String name, InetAddress host, int port, RemoteFileRepository remoteFileRepository) {
        this.controller = controller;
        this.name = name;
        this.host = host;
        this.port = port;
        this.remoteFileRepository = remoteFileRepository;
        remoteFileRepository.setRemoteFileRepositoryExecutor(this.remoteFileRepositoryExecutor);
    }

    public static Future<MasterDomainControllerClient> install(ServiceTarget serviceTarget, ModelController controller, String localHostName, String remoteDcHost, int remoteDcPort, String securityRealm, RemoteFileRepository remoteFileRepository) {
        RemoteDomainConnectionService service;
        try {
            service = new RemoteDomainConnectionService(controller, localHostName, InetAddress.getByName(remoteDcHost), remoteDcPort, remoteFileRepository);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        ServiceBuilder builder = serviceTarget.addService(MasterDomainControllerClient.SERVICE_NAME, (Service)service).addDependency(ManagementRemotingServices.MANAGEMENT_ENDPOINT, Endpoint.class, service.endpointInjector).setInitialMode(ServiceController.Mode.ACTIVE);
        if (securityRealm != null) {
            ServiceName callbackHandlerService = SecurityRealmService.BASE_SERVICE_NAME.append(new String[]{securityRealm}).append(new String[]{"secret"});
            builder.addDependency(callbackHandlerService, CallbackHandlerFactory.class, service.callbackFactoryInjector);
        }
        builder.install();
        return service.futureClient;
    }

    @Override
    public void register() {
        IllegalStateException ise = null;
        boolean connected = false;
        long timeout = 30000L;
        long endTime = System.currentTimeMillis() + 30000L;
        int retries = 0;
        while (!connected) {
            try {
                this.connect();
                connected = true;
                break;
            }
            catch (IllegalStateException e) {
                Throwable cause = e;
                while ((cause = cause.getCause()) != null) {
                    if (!(cause instanceof SaslException)) continue;
                    throw HostControllerMessages.MESSAGES.authenticationFailureUnableToConnect(cause);
                }
                if (System.currentTimeMillis() > endTime) {
                    throw HostControllerMessages.MESSAGES.connectionToMasterTimeout(e, retries, 30000L);
                }
                ise = e;
                try {
                    ReconnectPolicy.CONNECT.wait(retries);
                }
                catch (InterruptedException ie) {
                    throw HostControllerMessages.MESSAGES.connectionToMasterInterrupted();
                }
            }
            catch (HostAlreadyExistsException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
        this.connected.set(true);
        this.registered.set(true);
    }

    private synchronized void connect() {
        ProtocolChannelClient client;
        ProtocolChannelClient.Configuration configuration = new ProtocolChannelClient.Configuration();
        configuration.setEndpointName("endpoint");
        configuration.setUriScheme("remote");
        this.handler = new TransactionalModelControllerOperationHandler(this.controller, this.executor);
        try {
            configuration.setUri(new URI("remote://" + this.host.getHostAddress() + ":" + this.port));
            client = ProtocolChannelClient.create((ProtocolChannelClient.Configuration)configuration);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            CallbackHandler handler = null;
            CallbackHandlerFactory handlerFactory = (CallbackHandlerFactory)this.callbackFactoryInjector.getOptionalValue();
            if (handlerFactory != null) {
                handler = handlerFactory.getCallbackHandler(this.name);
            }
            Connection connection = client.connectSync(handler);
            this.channelClient = client;
            this.channel = (Channel)connection.openChannel("domain", OptionMap.EMPTY).get();
            this.channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

                public void handleClose(Channel closed, IOException exception) {
                    RemoteDomainConnectionService.this.connectionClosed();
                }
            });
            this.channel.receiveMessage(ManagementChannelReceiver.createDelegating((ManagementMessageHandler)this.handler));
            this.masterProxy = new ExistingChannelModelControllerClient(this.channel, this.executor);
        }
        catch (IOException e) {
            HostControllerLogger.ROOT_LOGGER.cannotConnect(this.host.getHostAddress(), this.port);
            throw new IllegalStateException(e);
        }
        SlaveRegistrationException error = null;
        try {
            error = (SlaveRegistrationException)new RegisterModelControllerRequest().executeForResult(this.handler, this.channel, null);
        }
        catch (Exception e) {
            HostControllerLogger.ROOT_LOGGER.errorRetrievingDomainModel(this.host.getHostAddress(), this.port, e.getLocalizedMessage());
            throw new IllegalStateException(e);
        }
        if (error != null) {
            if (error.getErrorCode() == SlaveRegistrationException.ErrorCode.HOST_ALREADY_EXISTS) {
                throw new HostAlreadyExistsException(error.getErrorMessage());
            }
            throw new IllegalStateException(error.getErrorMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void unregister() {
        if (!this.registered.get()) {
            return;
        }
        try {
            new UnregisterModelControllerRequest().executeForResult(this.handler, this.channel, null);
            this.registered.set(false);
        }
        catch (Exception e) {
            HostControllerLogger.ROOT_LOGGER.debugf(e, "Error unregistering from master", new Object[0]);
        }
        finally {
            this.channelClient.close();
        }
    }

    @Override
    public synchronized FileRepository getRemoteFileRepository() {
        return this.remoteFileRepository;
    }

    public ModelNode execute(ModelNode operation) throws IOException {
        return this.execute(operation, OperationMessageHandler.logging);
    }

    public ModelNode execute(Operation operation) throws IOException {
        return this.masterProxy.execute(operation, OperationMessageHandler.logging);
    }

    public ModelNode execute(ModelNode operation, OperationMessageHandler messageHandler) throws IOException {
        return this.masterProxy.execute(operation, messageHandler);
    }

    public ModelNode execute(Operation operation, OperationMessageHandler messageHandler) throws IOException {
        return this.masterProxy.execute(operation, messageHandler);
    }

    public AsyncFuture<ModelNode> executeAsync(ModelNode operation, OperationMessageHandler messageHandler) {
        return this.masterProxy.executeAsync(operation, messageHandler);
    }

    public AsyncFuture<ModelNode> executeAsync(Operation operation, OperationMessageHandler messageHandler) {
        return this.masterProxy.executeAsync(operation, messageHandler);
    }

    public void close() throws IOException {
        throw HostControllerMessages.MESSAGES.closeShouldBeManagedByService();
    }

    public synchronized void start(StartContext context) throws StartException {
        this.futureClient.setClient(this);
    }

    public synchronized void stop(StopContext context) {
        this.shutdown.set(true);
        if (this.channelClient != null) {
            this.unregister();
        }
    }

    public void connectionClosed() {
        if (!this.connected.get()) {
            HostControllerLogger.ROOT_LOGGER.nullReconnectInfo();
            return;
        }
        AbstractMessageHandler handler = this.handler;
        if (handler != null) {
            handler.shutdownNow();
        }
        if (!this.shutdown.get()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    int count = 0;
                    while (!RemoteDomainConnectionService.this.shutdown.get()) {
                        HostControllerLogger.ROOT_LOGGER.debug("Attempting reconnection to master...");
                        try {
                            RemoteDomainConnectionService.this.connect();
                            HostControllerLogger.ROOT_LOGGER.reconnectedToMaster();
                            break;
                        }
                        catch (Exception e) {
                            try {
                                ReconnectPolicy.RECONNECT.wait(++count);
                            }
                            catch (InterruptedException e2) {
                                Thread.currentThread().interrupt();
                                return;
                            }
                        }
                    }
                }
            }).start();
        }
    }

    public synchronized MasterDomainControllerClient getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    private static class HostAlreadyExistsException
    extends RuntimeException {
        public HostAlreadyExistsException(String msg) {
            super(msg);
        }
    }

    private class FutureClient
    extends AsyncFutureTask<MasterDomainControllerClient> {
        protected FutureClient() {
            super(null);
        }

        private void setClient(MasterDomainControllerClient client) {
            super.setResult((Object)client);
        }
    }

    private static interface RemoteFileRepositoryExecutor {
        public File getFile(String var1, byte var2, FileRepository var3);
    }

    static class RemoteFileRepository
    implements FileRepository {
        private final FileRepository localFileRepository;
        private volatile RemoteFileRepositoryExecutor remoteFileRepositoryExecutor;

        RemoteFileRepository(FileRepository localFileRepository) {
            this.localFileRepository = localFileRepository;
        }

        @Override
        public final File getFile(String relativePath) {
            return this.getFile(relativePath, (byte)38);
        }

        @Override
        public final File getConfigurationFile(String relativePath) {
            return this.getFile(relativePath, (byte)39);
        }

        @Override
        public final File[] getDeploymentFiles(byte[] deploymentHash) {
            String hex = deploymentHash == null ? "" : HashUtil.bytesToHexString((byte[])deploymentHash);
            return this.getFile(hex, (byte)40).listFiles();
        }

        @Override
        public File getDeploymentRoot(byte[] deploymentHash) {
            String hex = deploymentHash == null ? "" : HashUtil.bytesToHexString((byte[])deploymentHash);
            return this.getFile(hex, (byte)40);
        }

        private File getFile(String relativePath, byte repoId) {
            return this.remoteFileRepositoryExecutor.getFile(relativePath, repoId, this.localFileRepository);
        }

        private void setRemoteFileRepositoryExecutor(RemoteFileRepositoryExecutor remoteFileRepositoryExecutor) {
            this.remoteFileRepositoryExecutor = remoteFileRepositoryExecutor;
        }
    }

    private class GetFileRequest
    extends RegistryRequest<File> {
        private final byte rootId;
        private final String filePath;
        private final FileRepository localFileRepository;

        private GetFileRequest(byte rootId, String filePath, FileRepository localFileRepository) {
            this.rootId = rootId;
            this.filePath = filePath;
            this.localFileRepository = localFileRepository;
        }

        public byte getOperationType() {
            return 85;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<File> resultHandler, ManagementRequestContext<Void> context, FlushableDataOutput output) throws IOException {
            output.write(32);
            output.writeUTF(RemoteDomainConnectionService.this.name);
            output.writeByte(36);
            output.writeByte((int)this.rootId);
            output.writeByte(37);
            output.writeUTF(this.filePath);
            HostControllerLogger.ROOT_LOGGER.debugf("Requesting files for path %s", this.filePath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<File> resultHandler, ManagementRequestContext<Void> context) throws IOException {
            File localPath;
            switch (this.rootId) {
                case 38: {
                    localPath = this.localFileRepository.getFile(this.filePath);
                    break;
                }
                case 39: {
                    localPath = this.localFileRepository.getConfigurationFile(this.filePath);
                    break;
                }
                case 40: {
                    byte[] hash = HashUtil.hexStringToByteArray((String)this.filePath);
                    localPath = this.localFileRepository.getDeploymentRoot(hash);
                    break;
                }
                default: {
                    localPath = null;
                }
            }
            ProtocolUtils.expectHeader((DataInput)input, (int)41);
            int numFiles = input.readInt();
            HostControllerLogger.ROOT_LOGGER.debugf("Received %d files for %s", numFiles, localPath);
            switch (numFiles) {
                case -1: {
                    break;
                }
                case 0: {
                    if (localPath.mkdirs()) break;
                    throw HostControllerMessages.MESSAGES.cannotCreateLocalDirectory(localPath);
                }
                default: {
                    for (int i = 0; i < numFiles; ++i) {
                        long totalRead;
                        ProtocolUtils.expectHeader((DataInput)input, (int)48);
                        ProtocolUtils.expectHeader((DataInput)input, (int)37);
                        String path = input.readUTF();
                        ProtocolUtils.expectHeader((DataInput)input, (int)49);
                        long length = input.readLong();
                        HostControllerLogger.ROOT_LOGGER.debugf("Received file [%s] of length %d", path, length);
                        File file = new File(localPath, path);
                        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                            throw HostControllerMessages.MESSAGES.cannotCreateLocalDirectory(localPath.getParentFile());
                        }
                        OutputStream fileOut = null;
                        try {
                            int len;
                            fileOut = new BufferedOutputStream(new FileOutputStream(file));
                            byte[] buffer = new byte[8192];
                            for (totalRead = 0L; totalRead < length; totalRead += (long)len) {
                                len = Math.min((int)(length - totalRead), buffer.length);
                                input.readFully(buffer, 0, len);
                                fileOut.write(buffer, 0, len);
                            }
                        }
                        finally {
                            if (fileOut != null) {
                                fileOut.close();
                            }
                        }
                        if (totalRead != length) {
                            throw HostControllerMessages.MESSAGES.didNotReadEntireFile(length - totalRead);
                        }
                        ProtocolUtils.expectHeader((DataInput)input, (int)50);
                    }
                }
            }
            resultHandler.done((Object)localPath);
        }
    }

    private class UnregisterModelControllerRequest
    extends RegistryRequest<Void> {
        private UnregisterModelControllerRequest() {
        }

        public byte getOperationType() {
            return 83;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> voidManagementRequestContext, FlushableDataOutput output) throws IOException {
            output.write(32);
            output.writeUTF(RemoteDomainConnectionService.this.name);
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> voidManagementRequestContext) throws IOException {
            resultHandler.done(null);
        }
    }

    private class RegisterModelControllerRequest
    extends RegistryRequest<SlaveRegistrationException> {
        private RegisterModelControllerRequest() {
        }

        public byte getOperationType() {
            return 81;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<SlaveRegistrationException> resultHandler, ManagementRequestContext<Void> voidManagementRequestContext, FlushableDataOutput output) throws IOException {
            output.write(32);
            output.writeUTF(RemoteDomainConnectionService.this.name);
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<SlaveRegistrationException> resultHandler, ManagementRequestContext<Void> voidManagementRequestContext) throws IOException {
            byte status = input.readByte();
            if (status == 33) {
                resultHandler.done(null);
            } else {
                resultHandler.done((Object)SlaveRegistrationException.parse(input.readUTF()));
            }
        }
    }

    private abstract class RegistryRequest<T>
    extends AbstractManagementRequest<T, Void> {
        private RegistryRequest() {
        }
    }
}

