/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.remote.AbstractModelControllerOperationHandlerFactoryService;
import org.jboss.as.controller.remote.ModelControllerClientOperationHandlerFactoryService;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.UnregisteredHostChannelRegistry;
import org.jboss.as.host.controller.HostControllerLogger;
import org.jboss.as.host.controller.mgmt.MasterDomainControllerOperationHandlerImpl;
import org.jboss.msc.service.ServiceName;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.HandleableCloseable;

public class MasterDomainControllerOperationHandlerService
extends AbstractModelControllerOperationHandlerFactoryService {
    public static final ServiceName SERVICE_NAME = DomainController.SERVICE_NAME.append(ModelControllerClientOperationHandlerFactoryService.OPERATION_HANDLER_NAME_SUFFIX);
    private final DomainController domainController;
    private final UnregisteredHostChannelRegistry registry;

    public MasterDomainControllerOperationHandlerService(DomainController domainController, UnregisteredHostChannelRegistry registry) {
        this.domainController = domainController;
        this.registry = registry;
    }

    public HandleableCloseable.Key startReceiving(Channel channel) {
        final MasterDomainControllerOperationHandlerImpl handler = new MasterDomainControllerOperationHandlerImpl(this.getExecutor(), this.getController(), this.registry, this.domainController);
        HandleableCloseable.Key key = channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleClose(Channel closed, IOException exception) {
                handler.shutdown();
                try {
                    handler.awaitCompletion(100L, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    HostControllerLogger.ROOT_LOGGER.serviceShutdownIncomplete(e);
                }
                finally {
                    handler.shutdownNow();
                }
            }
        });
        channel.receiveMessage((Channel.Receiver)handler);
        return key;
    }
}

