/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.operations.common.ProcessEnvironment;
import org.jboss.as.controller.persistence.ConfigurationFile;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.SecurityActions;
import org.jboss.as.process.DefaultJvmUtils;
import org.jboss.as.version.ProductConfig;

public class HostControllerEnvironment
extends ProcessEnvironment {
    public static final String HOME_DIR = "jboss.home.dir";
    @Deprecated
    public static final String MODULES_DIR = "jboss.modules.dir";
    public static final String DOMAIN_BASE_DIR = "jboss.domain.base.dir";
    public static final String DOMAIN_CONFIG_DIR = "jboss.domain.config.dir";
    public static final String DOMAIN_DATA_DIR = "jboss.domain.data.dir";
    public static final String DOMAIN_CONTENT_DIR = "jboss.domain.content.dir";
    @Deprecated
    public static final String DOMAIN_DEPLOYMENT_DIR = "jboss.domain.deployment.dir";
    public static final String DOMAIN_LOG_DIR = "jboss.domain.log.dir";
    public static final String DOMAIN_SERVERS_DIR = "jboss.domain.servers.dir";
    public static final String DOMAIN_TEMP_DIR = "jboss.domain.temp.dir";
    public static final String HOST_NAME = "jboss.host.name";
    public static final String QUALIFIED_HOST_NAME = "jboss.qualified.host.name";
    public static final String CONTROLLER_TEMP_DIR = "jboss.controller.temp.dir";
    public static final String JBOSS_BIND_ADDRESS = "jboss.bind.address";
    public static final String JBOSS_BIND_ADDRESS_PREFIX = "jboss.bind.address.";
    public static final String JBOSS_DEFAULT_MULTICAST_ADDRESS = "jboss.default.multicast.address";
    public static final String JBOSS_DOMAIN_MASTER_ADDRESS = "jboss.domain.master.address";
    public static final String JBOSS_DOMAIN_MASTER_PORT = "jboss.domain.master.port";
    public static final String JBOSS_DOMAIN_DEFAULT_CONFIG = "jboss.domain.default.config";
    public static final String JBOSS_HOST_DEFAULT_CONFIG = "jboss.host.default.config";
    private final Map<String, String> hostSystemProperties;
    private final InetAddress processControllerAddress;
    private final Integer processControllerPort;
    private final InetAddress hostControllerAddress;
    private final Integer hostControllerPort;
    private final File homeDir;
    private final File modulesDir;
    private final File domainBaseDir;
    private final File domainConfigurationDir;
    private final ConfigurationFile hostConfigurationFile;
    private final ConfigurationFile domainConfigurationFile;
    private final File domainContentDir;
    private final File domainDataDir;
    private final File domainLogDir;
    private final File domainServersDir;
    private final File domainTempDir;
    private final File defaultJVM;
    private final boolean isRestart;
    private final boolean backupDomainFiles;
    private final boolean useCachedDc;
    private final RunningMode initialRunningMode;
    private final ProductConfig productConfig;
    private final String qualifiedHostName;
    private final String hostName;
    private String hostControllerName;

    public HostControllerEnvironment(Map<String, String> hostSystemProperties, boolean isRestart, InetAddress processControllerAddress, Integer processControllerPort, InetAddress hostControllerAddress, Integer hostControllerPort, String defaultJVM, String domainConfig, String hostConfig, RunningMode initialRunningMode, boolean backupDomainFiles, boolean useCachedDc, ProductConfig productConfig) {
        if (hostSystemProperties == null) {
            throw HostControllerMessages.MESSAGES.nullVar("hostSystemProperties");
        }
        this.hostSystemProperties = Collections.unmodifiableMap(hostSystemProperties);
        if (processControllerAddress == null) {
            throw HostControllerMessages.MESSAGES.nullVar("processControllerAddress");
        }
        if (processControllerPort == null) {
            throw HostControllerMessages.MESSAGES.nullVar("processControllerPort");
        }
        if (hostControllerAddress == null) {
            throw HostControllerMessages.MESSAGES.nullVar("hostControllerAddress");
        }
        if (hostControllerPort == null) {
            throw HostControllerMessages.MESSAGES.nullVar("hostControllerPort");
        }
        this.processControllerPort = processControllerPort;
        this.processControllerAddress = processControllerAddress;
        this.hostControllerAddress = hostControllerAddress;
        this.hostControllerPort = hostControllerPort;
        this.isRestart = isRestart;
        String hostName = hostSystemProperties.get(HOST_NAME);
        String qualifiedHostName = hostSystemProperties.get(QUALIFIED_HOST_NAME);
        if (qualifiedHostName == null) {
            Map<String, String> env = null;
            qualifiedHostName = hostName;
            if (qualifiedHostName == null) {
                env = SecurityActions.getSystemEnvironment();
                qualifiedHostName = env.get("HOSTNAME");
            }
            if (qualifiedHostName == null) {
                qualifiedHostName = env.get("COMPUTERNAME");
            }
            if (qualifiedHostName == null) {
                try {
                    qualifiedHostName = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    qualifiedHostName = null;
                }
            }
            if (qualifiedHostName != null && qualifiedHostName.matches("^\\d+\\.\\d+\\.\\d+\\.\\d+$|:")) {
                qualifiedHostName = null;
            }
            if (qualifiedHostName == null) {
                qualifiedHostName = "unknown-host.unknown-domain";
            }
            qualifiedHostName = qualifiedHostName.trim().toLowerCase();
        }
        this.qualifiedHostName = qualifiedHostName;
        this.hostControllerName = qualifiedHostName;
        if (hostName == null) {
            int idx = qualifiedHostName.indexOf(46);
            hostName = idx == -1 ? qualifiedHostName : qualifiedHostName.substring(0, idx);
        }
        this.hostName = hostName;
        File home = this.getFileFromProperty(HOME_DIR);
        if (home == null) {
            home = new File(System.getProperty("user.dir"));
        }
        this.homeDir = home;
        SecurityActions.setSystemProperty(HOME_DIR, this.homeDir.getAbsolutePath());
        File tmp = this.getFileFromProperty(MODULES_DIR);
        if (tmp == null) {
            tmp = new File(this.homeDir, "modules");
        }
        this.modulesDir = tmp;
        String deprecatedModDir = MODULES_DIR;
        SecurityActions.setSystemProperty(deprecatedModDir, this.modulesDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_BASE_DIR);
        if (tmp == null) {
            tmp = new File(this.homeDir, "domain");
        }
        this.domainBaseDir = tmp;
        SecurityActions.setSystemProperty(DOMAIN_BASE_DIR, this.domainBaseDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_CONFIG_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "configuration");
        }
        this.domainConfigurationDir = tmp;
        SecurityActions.setSystemProperty(DOMAIN_CONFIG_DIR, this.domainConfigurationDir.getAbsolutePath());
        String defaultHostConfig = SecurityActions.getSystemProperty(JBOSS_HOST_DEFAULT_CONFIG, "host.xml");
        this.hostConfigurationFile = new ConfigurationFile(this.domainConfigurationDir, defaultHostConfig, hostConfig);
        String defaultDomainConfig = SecurityActions.getSystemProperty(JBOSS_DOMAIN_DEFAULT_CONFIG, "domain.xml");
        this.domainConfigurationFile = new ConfigurationFile(this.domainConfigurationDir, defaultDomainConfig, domainConfig);
        tmp = this.getFileFromProperty(DOMAIN_DATA_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "data");
        }
        this.domainDataDir = tmp;
        SecurityActions.setSystemProperty(DOMAIN_DATA_DIR, this.domainDataDir.getAbsolutePath());
        String deprecatedDepDir = DOMAIN_DEPLOYMENT_DIR;
        tmp = this.getFileFromProperty(DOMAIN_CONTENT_DIR);
        if (tmp == null) {
            tmp = this.getFileFromProperty(deprecatedDepDir);
        }
        if (tmp == null) {
            tmp = new File(this.domainDataDir, "content");
        }
        this.domainContentDir = tmp;
        SecurityActions.setSystemProperty(DOMAIN_CONTENT_DIR, this.domainContentDir.getAbsolutePath());
        SecurityActions.setSystemProperty(deprecatedDepDir, this.domainContentDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_LOG_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "log");
        }
        this.domainLogDir = tmp;
        SecurityActions.setSystemProperty(DOMAIN_LOG_DIR, this.domainLogDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_SERVERS_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "servers");
        }
        this.domainServersDir = tmp;
        SecurityActions.setSystemProperty(DOMAIN_SERVERS_DIR, this.domainServersDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_TEMP_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "tmp");
        }
        this.domainTempDir = tmp;
        SecurityActions.setSystemProperty(DOMAIN_TEMP_DIR, this.domainTempDir.getAbsolutePath());
        if (defaultJVM != null) {
            if (defaultJVM.equals("java")) {
                defaultJVM = DefaultJvmUtils.findJavaExecutable((String)DefaultJvmUtils.getCurrentJvmHome());
            }
            this.defaultJVM = new File(defaultJVM);
        } else {
            this.defaultJVM = null;
        }
        this.backupDomainFiles = backupDomainFiles;
        this.useCachedDc = useCachedDc;
        this.initialRunningMode = initialRunningMode;
        this.productConfig = productConfig;
    }

    public InetAddress getProcessControllerAddress() {
        return this.processControllerAddress;
    }

    public Integer getProcessControllerPort() {
        return this.processControllerPort;
    }

    public InetAddress getHostControllerAddress() {
        return this.hostControllerAddress;
    }

    public Integer getHostControllerPort() {
        return this.hostControllerPort;
    }

    public boolean isRestart() {
        return this.isRestart;
    }

    public boolean isBackupDomainFiles() {
        return this.backupDomainFiles;
    }

    public boolean isUseCachedDc() {
        return this.useCachedDc;
    }

    public RunningMode getInitialRunningMode() {
        return this.initialRunningMode;
    }

    public ProductConfig getProductConfig() {
        return this.productConfig;
    }

    public File getHomeDir() {
        return this.homeDir;
    }

    @Deprecated
    public File getModulesDir() {
        return this.modulesDir;
    }

    public File getDomainBaseDir() {
        return this.domainBaseDir;
    }

    public File getDomainConfigurationDir() {
        return this.domainConfigurationDir;
    }

    public File getDomainDataDir() {
        return this.domainDataDir;
    }

    public File getDomainContentDir() {
        return this.domainContentDir;
    }

    @Deprecated
    public File getDomainDeploymentDir() {
        return this.domainContentDir;
    }

    public File getDomainLogDir() {
        return this.domainLogDir;
    }

    public File getDomainServersDir() {
        return this.domainServersDir;
    }

    public File getDomainTempDir() {
        return this.domainTempDir;
    }

    public File getDefaultJVM() {
        return this.defaultJVM;
    }

    public Map<String, String> getHostSystemProperties() {
        return this.hostSystemProperties;
    }

    public String getQualifiedHostName() {
        return this.qualifiedHostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostControllerName() {
        return this.hostControllerName;
    }

    protected String getProcessName() {
        return this.hostControllerName;
    }

    protected void setProcessName(String processName) {
        if (processName != null) {
            this.hostControllerName = processName;
        }
    }

    protected boolean isRuntimeSystemPropertyUpdateAllowed(String propertyName, String propertyValue, boolean bootTime) {
        throw HostControllerMessages.MESSAGES.hostControllerSystemPropertyUpdateNotSupported();
    }

    protected void systemPropertyUpdated(String propertyName, String propertyValue) {
    }

    ConfigurationFile getHostConfigurationFile() {
        return this.hostConfigurationFile;
    }

    ConfigurationFile getDomainConfigurationFile() {
        return this.domainConfigurationFile;
    }

    private File getFileFromProperty(String name) {
        File relative;
        File result;
        String value = this.hostSystemProperties.get(name);
        File file = result = value != null ? new File(value) : null;
        if (result != null && this.homeDir != null && !result.exists() && !result.isAbsolute() && (relative = new File(this.homeDir, value)).exists()) {
            result = relative;
        }
        return result;
    }
}

