/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.IOException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.controller.remote.TransactionalProtocolHandlers;
import org.jboss.as.host.controller.ManagedServer;
import org.jboss.as.protocol.ProtocolMessages;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.AsyncFuture;

class ManagedServerProxy
implements TransactionalProtocolClient {
    private static final TransactionalProtocolClient DISCONNECTED = new DisconnectedProtocolClient();
    private final ModelNode address;
    private final ManagedServer server;
    private volatile TransactionalProtocolClient remoteClient;

    ManagedServerProxy(ManagedServer server, PathAddress address) {
        this.server = server;
        this.address = address.toModelNode();
        this.remoteClient = DISCONNECTED;
    }

    boolean isConnected() {
        return this.remoteClient != DISCONNECTED;
    }

    synchronized void connected(TransactionalProtocolClient remoteClient) {
        this.remoteClient = remoteClient;
    }

    synchronized boolean disconnected(TransactionalProtocolClient old) {
        if (this.remoteClient == old) {
            this.remoteClient = DISCONNECTED;
            return true;
        }
        return false;
    }

    public AsyncFuture<ModelNode> execute(TransactionalProtocolClient.TransactionalOperationListener<TransactionalProtocolClient.Operation> listener, ModelNode operation, OperationMessageHandler messageHandler, OperationAttachments attachments) throws IOException {
        return this.execute(listener, TransactionalProtocolHandlers.wrap((ModelNode)operation, (OperationMessageHandler)messageHandler, (OperationAttachments)attachments));
    }

    public <T extends TransactionalProtocolClient.Operation> AsyncFuture<ModelNode> execute(TransactionalProtocolClient.TransactionalOperationListener<T> listener, T operation) throws IOException {
        ModelNode op;
        if (!this.isConnected() && "server-set-restart-required".equals((op = operation.getOperation()).get("operation").asString())) {
            this.server.requireReload();
        }
        return this.remoteClient.execute(listener, operation);
    }

    static boolean isUserOperation(ModelNode op) {
        return op.hasDefined("operation-headers") && op.get("operation-headers").hasDefined("caller-type") && "user".equals(op.get(new String[]{"operation-headers", "caller-type"}).asString());
    }

    static final class DisconnectedProtocolClient
    implements TransactionalProtocolClient {
        DisconnectedProtocolClient() {
        }

        public AsyncFuture<ModelNode> execute(TransactionalProtocolClient.TransactionalOperationListener<TransactionalProtocolClient.Operation> listener, ModelNode operation, OperationMessageHandler messageHandler, OperationAttachments attachments) throws IOException {
            return this.execute(listener, TransactionalProtocolHandlers.wrap((ModelNode)operation, (OperationMessageHandler)messageHandler, (OperationAttachments)attachments));
        }

        public <T extends TransactionalProtocolClient.Operation> AsyncFuture<ModelNode> execute(TransactionalProtocolClient.TransactionalOperationListener<T> listener, T operation) throws IOException {
            throw ProtocolMessages.MESSAGES.channelClosed();
        }
    }
}

