/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.logging.AbstractFormatterSpec;
import org.jboss.as.logging.AbstractHandlerElement;
import org.jboss.as.logging.AbstractLoggingSubsystemUpdate;
import org.jboss.as.logging.HandlerRemove;
import org.jboss.as.logging.LoggingSubsystemElement;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.UpdateFailedException;

public abstract class AbstractHandlerAdd
extends AbstractLoggingSubsystemUpdate<Void> {
    private static final long serialVersionUID = 5791037187352350769L;
    private final String name;
    private String levelName;
    private Boolean autoflush;
    private String encoding;
    private AbstractFormatterSpec formatter;
    private String[] subhandlers;

    protected AbstractHandlerAdd(String name) {
        this.name = name;
    }

    public AbstractSubsystemUpdate<LoggingSubsystemElement, ?> getCompensatingUpdate(LoggingSubsystemElement original) {
        return new HandlerRemove(this.name);
    }

    protected void applyUpdate(LoggingSubsystemElement element) throws UpdateFailedException {
        AbstractHandlerElement<?> handler = this.createElement(this.name);
        handler.setLevelName(this.levelName);
        handler.setAutoflush(this.autoflush);
        handler.setEncoding(this.encoding);
        this.formatter.apply(handler);
        if (this.subhandlers != null) {
            handler.setSubhandlers(this.subhandlers);
        }
        element.addHandler(handler.getName(), handler);
    }

    protected abstract AbstractHandlerElement<?> createElement(String var1);

    public void setLevelName(String levelName) {
        this.levelName = levelName;
    }

    public void setAutoflush(Boolean autoflush) {
        this.autoflush = autoflush;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setFormatter(AbstractFormatterSpec formatter) {
        this.formatter = formatter;
    }

    public void setSubhandlers(String ... subhandlers) {
        this.subhandlers = subhandlers;
    }

    public String[] getSubhandlers() {
        return this.subhandlers;
    }

    public AbstractFormatterSpec getFormatter() {
        return this.formatter;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Boolean getAutoflush() {
        return this.autoflush;
    }

    public String getLevelName() {
        return this.levelName;
    }

    public String getName() {
        return this.name;
    }
}

