/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.logging.AbstractFormatterElement;
import org.jboss.as.logging.AbstractHandlerAdd;
import org.jboss.as.model.AbstractModelRootElement;
import org.jboss.as.model.PropertiesElement;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public abstract class AbstractHandlerElement<E extends AbstractHandlerElement<E>>
extends AbstractModelRootElement<E> {
    private static final long serialVersionUID = -8326499785021909600L;
    private static final String[] NONE = new String[0];
    private final String name;
    private String[] subhandlers = NONE;
    private String encoding;
    private Boolean autoflush;
    private String levelName;
    private AbstractFormatterElement<?> formatter;
    private PropertiesElement properties;

    protected AbstractHandlerElement(String name, QName elementName) {
        super(elementName);
        this.name = name;
    }

    public List<String> getSubhandlers() {
        return Arrays.asList((Object[])this.subhandlers.clone());
    }

    public String getName() {
        return this.name;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Boolean getAutoflush() {
        return this.autoflush;
    }

    public String getLevelName() {
        return this.levelName;
    }

    public AbstractFormatterElement<?> getFormatter() {
        return this.formatter;
    }

    public PropertiesElement getProperties() {
        return this.properties;
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        this.writeAttributes(streamWriter);
        this.writeElements(streamWriter);
        streamWriter.writeEndElement();
    }

    protected void writeElements(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        if (this.levelName != null) {
            streamWriter.writeEmptyElement("level");
            streamWriter.writeAttribute("name", this.levelName);
        }
        if (this.formatter != null) {
            streamWriter.writeStartElement("formatter");
            QName elementName = this.formatter.getElementName();
            streamWriter.writeStartElement(elementName.getNamespaceURI(), elementName.getLocalPart());
            this.formatter.writeContent(streamWriter);
            streamWriter.writeEndElement();
        }
        if (this.subhandlers != null && this.subhandlers.length > 0) {
            streamWriter.writeStartElement("subhandlers");
            for (String name : this.subhandlers) {
                streamWriter.writeEmptyElement("handler");
                streamWriter.writeAttribute("name", name);
            }
            streamWriter.writeEndElement();
        }
        if (this.properties != null && this.properties.size() > 0) {
            streamWriter.writeStartElement("properties");
            this.properties.writeContent(streamWriter);
        }
    }

    protected void writeAttributes(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        if (this.name != null) {
            streamWriter.writeAttribute("name", this.name);
        }
        if (this.autoflush != null) {
            streamWriter.writeAttribute("autoflush", this.autoflush.toString());
        }
        if (this.encoding != null) {
            streamWriter.writeAttribute("encoding", this.encoding.toString());
        }
    }

    void setLevelName(String levelName) {
        this.levelName = levelName;
    }

    void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    void setAutoflush(Boolean autoflush) {
        this.autoflush = autoflush;
    }

    void setFormatter(AbstractFormatterElement<?> formatter) {
        this.formatter = formatter;
    }

    void setProperties(PropertiesElement properties) {
        this.properties = properties;
    }

    void setSubhandlers(String[] subhandlers) {
        this.subhandlers = (String[])subhandlers.clone();
    }

    AbstractHandlerAdd getAdd() {
        AbstractHandlerAdd add = this.createAdd(this.name);
        add.setLevelName(this.levelName);
        add.setAutoflush(this.autoflush);
        add.setEncoding(this.encoding);
        add.setFormatter(this.formatter.getSpecification());
        add.setSubhandlers((String[])this.subhandlers.clone());
        return add;
    }

    abstract AbstractHandlerAdd createAdd(String var1);
}

