/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.logging.Attribute;
import org.jboss.as.logging.Element;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public abstract class AbstractLoggerElement<E extends AbstractLoggerElement<E>>
extends AbstractModelElement<E> {
    private static final long serialVersionUID = -4071924125278221764L;
    private List<String> handlers = new ArrayList<String>();
    private String level;

    AbstractLoggerElement() {
    }

    void setLevel(String level) {
        this.level = level;
    }

    public List<String> getHandlers() {
        return this.handlers;
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        this.writeAttributes(streamWriter);
        if (this.level != null) {
            streamWriter.writeEmptyElement(Element.LEVEL.getLocalName());
            streamWriter.writeAttribute(Attribute.NAME.getLocalName(), this.level);
        }
        if (this.handlers != null && this.handlers.size() > 0) {
            streamWriter.writeStartElement(Element.HANDLERS.getLocalName());
            for (String handler : this.handlers) {
                streamWriter.writeEmptyElement(Element.HANDLER.getLocalName());
                streamWriter.writeAttribute(Attribute.NAME.getLocalName(), handler);
            }
            streamWriter.writeEndElement();
        }
        streamWriter.writeEndElement();
    }

    public String getLevel() {
        return this.level;
    }

    protected abstract void writeAttributes(XMLExtendedStreamWriter var1) throws XMLStreamException;
}

