/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.as.logging.AbstractHandlerAdd;
import org.jboss.as.logging.AbstractHandlerElement;
import org.jboss.as.logging.AsyncHandlerElement;
import org.jboss.as.logging.AsyncHandlerService;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.OverflowAction;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.value.InjectedValue;

public class AsyncHandlerAdd
extends AbstractHandlerAdd {
    private static final long serialVersionUID = 3144252544518106859L;
    private OverflowAction overflowAction;
    private int queueLength;

    protected AsyncHandlerAdd(String name) {
        super(name);
    }

    @Override
    protected AbstractHandlerElement<?> createElement(String name) {
        AsyncHandlerElement element = new AsyncHandlerElement(name);
        element.setOverflowAction(this.overflowAction);
        element.setQueueLength(this.queueLength);
        element.setSubhandlers(this.getSubhandlers());
        return element;
    }

    public OverflowAction getOverflowAction() {
        return this.overflowAction;
    }

    public void setOverflowAction(OverflowAction overflowAction) {
        this.overflowAction = overflowAction;
    }

    public int getQueueLength() {
        return this.queueLength;
    }

    public void setQueueLength(int queueLength) {
        this.queueLength = queueLength;
    }

    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        try {
            BatchBuilder builder = updateContext.getBatchBuilder();
            AsyncHandlerService service = new AsyncHandlerService();
            BatchServiceBuilder serviceBuilder = builder.addService(LogServices.handlerName(this.getName()), (Service)service);
            ArrayList<InjectedValue<Handler>> list = new ArrayList<InjectedValue<Handler>>();
            for (String handlerName : this.getSubhandlers()) {
                InjectedValue injectedValue = new InjectedValue();
                serviceBuilder.addDependency(LogServices.handlerName(handlerName), Handler.class, (Injector)injectedValue);
                list.add((InjectedValue<Handler>)injectedValue);
            }
            service.addHandlers(list);
            service.setQueueLength(this.queueLength);
            service.setLevel(Level.parse(this.getLevelName()));
            service.setOverflowAction(this.overflowAction);
            serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
            serviceBuilder.addListener((ServiceListener)new UpdateResultHandler.ServiceStartListener(resultHandler, param));
        }
        catch (Throwable t) {
            resultHandler.handleFailure(t, param);
            return;
        }
    }
}

