/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import org.jboss.as.logging.AbstractHandlerAdd;
import org.jboss.as.logging.AbstractHandlerElement;
import org.jboss.as.logging.ConsoleHandlerElement;
import org.jboss.as.logging.ConsoleHandlerService;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.Target;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public class ConsoleHandlerAdd
extends AbstractHandlerAdd {
    private static final long serialVersionUID = -4769503787024853339L;
    private Target target = Target.SYSTEM_OUT;

    public ConsoleHandlerAdd(String name) {
        super(name);
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    @Override
    protected AbstractHandlerElement<?> createElement(String name) {
        ConsoleHandlerElement element = new ConsoleHandlerElement(name);
        element.setTarget(this.target);
        return element;
    }

    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> handler, P param) {
        try {
            BatchBuilder builder = updateContext.getBatchBuilder();
            ConsoleHandlerService service = new ConsoleHandlerService();
            BatchServiceBuilder serviceBuilder = builder.addService(LogServices.handlerName(this.getName()), (Service)service);
            service.setLevel(Level.parse(this.getLevelName()));
            Boolean autoFlush = this.getAutoflush();
            if (autoFlush != null) {
                service.setAutoflush(autoFlush);
            }
            try {
                service.setEncoding(this.getEncoding());
            }
            catch (UnsupportedEncodingException e) {
                handler.handleFailure((Throwable)e, param);
                return;
            }
            service.setFormatterSpec(this.getFormatter());
            serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
            serviceBuilder.addListener((ServiceListener)new UpdateResultHandler.ServiceStartListener(handler, param));
        }
        catch (Throwable t) {
            handler.handleFailure(t, param);
            return;
        }
    }
}

