/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.logging.AbstractLoggingSubsystemUpdate;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.LoggerHandlerAdd;
import org.jboss.as.logging.LoggingSubsystemElement;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public final class LoggerHandlerRemove
extends AbstractLoggingSubsystemUpdate<Void> {
    private static final long serialVersionUID = 1370469831899844699L;
    private final String loggerName;
    private final String handlerName;

    public LoggerHandlerRemove(String loggerName, String handlerName) {
        this.loggerName = loggerName;
        this.handlerName = handlerName;
    }

    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> handler, P param) {
        try {
            ServiceController controller = updateContext.getServiceContainer().getRequiredService(LogServices.loggerHandlerName(this.loggerName, this.handlerName));
            controller.setMode(ServiceController.Mode.REMOVE);
            controller.addListener((ServiceListener)new UpdateResultHandler.ServiceRemoveListener(handler, param));
        }
        catch (Throwable t) {
            handler.handleFailure(t, param);
        }
    }

    public AbstractSubsystemUpdate<LoggingSubsystemElement, ?> getCompensatingUpdate(LoggingSubsystemElement original) {
        return new LoggerHandlerAdd(this.loggerName, this.handlerName);
    }

    protected void applyUpdate(LoggingSubsystemElement element) throws UpdateFailedException {
        element.getLogger(this.loggerName).getHandlers().remove(this.handlerName);
    }
}

