/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.logging.AbstractHandlerElement;
import org.jboss.as.logging.AbstractLoggerElement;
import org.jboss.as.logging.Element;
import org.jboss.as.logging.LoggerAdd;
import org.jboss.as.logging.LoggerElement;
import org.jboss.as.logging.LoggerHandlerAdd;
import org.jboss.as.logging.LoggingSubsystemAdd;
import org.jboss.as.logging.Namespace;
import org.jboss.as.logging.RootLoggerAdd;
import org.jboss.as.logging.RootLoggerElement;
import org.jboss.as.model.AbstractSubsystemElement;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class LoggingSubsystemElement
extends AbstractSubsystemElement<LoggingSubsystemElement> {
    private static final long serialVersionUID = -615878954033668252L;
    private RootLoggerElement rootLoggerElement;
    private final NavigableMap<String, LoggerElement> loggers = new TreeMap<String, LoggerElement>();
    private final NavigableMap<String, AbstractHandlerElement<?>> handlers = new TreeMap();

    public LoggingSubsystemElement() {
        super(Namespace.LOGGING_1_0.getUriString());
    }

    boolean addLogger(LoggerElement logger) {
        String name = logger.getName();
        if (this.loggers.containsKey(name)) {
            return false;
        }
        this.loggers.put(name, logger);
        return true;
    }

    RootLoggerElement getRootLogger() {
        return this.rootLoggerElement;
    }

    boolean setRootLogger(RootLoggerElement rootLoggerElement) {
        if (this.rootLoggerElement != null) {
            return false;
        }
        this.rootLoggerElement = rootLoggerElement;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RootLoggerElement clearRootLogger() {
        try {
            RootLoggerElement rootLoggerElement = this.rootLoggerElement;
            return rootLoggerElement;
        }
        finally {
            this.rootLoggerElement = null;
        }
    }

    LoggerElement getLogger(String name) {
        return (LoggerElement)((Object)this.loggers.get(name));
    }

    LoggerElement removeLogger(String name) {
        return (LoggerElement)((Object)this.loggers.remove(name));
    }

    boolean addHandler(String name, AbstractHandlerElement<?> handler) {
        if (this.handlers.containsKey(name)) {
            return false;
        }
        this.handlers.put(name, handler);
        return true;
    }

    AbstractHandlerElement<?> getHandler(String name) {
        return (AbstractHandlerElement)((Object)this.handlers.get(name));
    }

    AbstractHandlerElement<?> removeHandler(String name) {
        return (AbstractHandlerElement)((Object)this.handlers.remove(name));
    }

    protected Class<LoggingSubsystemElement> getElementClass() {
        return LoggingSubsystemElement.class;
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        for (Object element : this.handlers.values()) {
            QName elementName = element.getElementName();
            streamWriter.writeStartElement(elementName.getNamespaceURI(), elementName.getLocalPart());
            ((AbstractHandlerElement)((Object)element)).writeContent(streamWriter);
        }
        for (Object element : this.loggers.descendingMap().values()) {
            streamWriter.writeStartElement(Element.LOGGER.getLocalName());
            ((AbstractLoggerElement)((Object)element)).writeContent(streamWriter);
        }
        RootLoggerElement rootLoggerElement = this.rootLoggerElement;
        if (rootLoggerElement != null) {
            streamWriter.writeStartElement(Element.ROOT_LOGGER.getLocalName());
            rootLoggerElement.writeContent(streamWriter);
        }
        streamWriter.writeEndElement();
    }

    protected void getUpdates(List<? super AbstractSubsystemUpdate<LoggingSubsystemElement, ?>> list) {
        if (this.rootLoggerElement != null) {
            RootLoggerAdd rootLoggerAdd = new RootLoggerAdd();
            rootLoggerAdd.setLevelName(this.rootLoggerElement.getLevel());
            list.add(rootLoggerAdd);
            for (String handlerName : this.rootLoggerElement.getHandlers()) {
                list.add(new LoggerHandlerAdd("", handlerName));
            }
        }
        for (LoggerElement element : this.loggers.values()) {
            String name = element.getName();
            LoggerAdd add = new LoggerAdd(name);
            add.setLevelName(element.getLevel());
            add.setUseParentHandlers(element.isUseParentHandlers());
            list.add(add);
            for (String handlerName : element.getHandlers()) {
                list.add(new LoggerHandlerAdd(name, handlerName));
            }
        }
        for (AbstractHandlerElement handlerElement : this.handlers.values()) {
            list.add(handlerElement.getAdd());
        }
    }

    protected boolean isEmpty() {
        return this.rootLoggerElement == null && this.loggers.isEmpty() && this.handlers.isEmpty();
    }

    protected LoggingSubsystemAdd getAdd() {
        return new LoggingSubsystemAdd();
    }

    protected <P> void applyRemove(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
    }
}

