/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.logging.Formatter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.logging.AbstractFormatterElement;
import org.jboss.as.logging.AbstractFormatterSpec;
import org.jboss.as.logging.Element;
import org.jboss.as.logging.Namespace;
import org.jboss.as.logging.PatternFormatterSpec;
import org.jboss.logmanager.formatters.PatternFormatter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class PatternFormatterElement
extends AbstractFormatterElement<PatternFormatterElement> {
    private static final long serialVersionUID = 2260770166892253338L;
    private static final QName ELEMENT_NAME = new QName(Namespace.CURRENT.getUriString(), Element.PATTERN_FORMATTER.getLocalName());
    private final String pattern;

    protected PatternFormatterElement(String pattern) {
        super(ELEMENT_NAME);
        if (pattern == null) {
            throw new IllegalArgumentException("pattern is null");
        }
        this.pattern = pattern;
    }

    @Override
    protected Formatter createFormatter() {
        return new PatternFormatter(this.pattern);
    }

    protected Class<PatternFormatterElement> getElementClass() {
        return PatternFormatterElement.class;
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeAttribute("pattern", this.pattern);
        streamWriter.writeEndElement();
    }

    @Override
    public AbstractFormatterSpec getSpecification() {
        return new PatternFormatterSpec(this.pattern);
    }
}

