/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.logging.Level;
import org.jboss.as.logging.AbstractLoggerAdd;
import org.jboss.as.logging.AbstractLoggerElement;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.LoggingSubsystemElement;
import org.jboss.as.logging.RootLoggerElement;
import org.jboss.as.logging.RootLoggerService;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public class RootLoggerAdd
extends AbstractLoggerAdd {
    private static final long serialVersionUID = 4230922005791983261L;

    @Override
    protected String getLoggerName() {
        return "";
    }

    @Override
    protected AbstractLoggerElement<?> addNewElement(LoggingSubsystemElement element) throws UpdateFailedException {
        RootLoggerElement newElement = new RootLoggerElement();
        if (!element.setRootLogger(newElement)) {
            throw new UpdateFailedException("Root logger already defined");
        }
        return newElement;
    }

    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        try {
            RootLoggerService service = new RootLoggerService();
            service.setLevel(Level.parse(this.getLevelName()));
            BatchBuilder batchBuilder = updateContext.getBatchBuilder();
            BatchServiceBuilder builder = batchBuilder.addService(LogServices.ROOT_LOGGER, (Service)service);
            builder.setInitialMode(ServiceController.Mode.ACTIVE);
            builder.addListener((ServiceListener)new UpdateResultHandler.ServiceStartListener(resultHandler, param));
        }
        catch (Throwable t) {
            resultHandler.handleFailure(t, param);
            return;
        }
    }
}

