/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.logging.AbstractFileHandlerElement;
import org.jboss.as.logging.AbstractHandlerAdd;
import org.jboss.as.logging.Attribute;
import org.jboss.as.logging.Element;
import org.jboss.as.logging.Namespace;
import org.jboss.as.logging.SizeRotatingFileHandlerAdd;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class SizeRotatingFileHandlerElement
extends AbstractFileHandlerElement<SizeRotatingFileHandlerElement> {
    private static final long serialVersionUID = -9214638141059862173L;
    private static final QName ELEMENT_NAME = new QName(Namespace.CURRENT.getUriString(), Element.SIZE_ROTATING_FILE_HANDLER.getLocalName());
    private long rotateSize;
    private int maxBackupIndex;

    protected SizeRotatingFileHandlerElement(String name) {
        super(name, ELEMENT_NAME);
    }

    protected Class<SizeRotatingFileHandlerElement> getElementClass() {
        return SizeRotatingFileHandlerElement.class;
    }

    void setRotateSize(long rotateSize) {
        this.rotateSize = rotateSize;
    }

    void setMaxBackupIndex(int maxBackupIndex) {
        this.maxBackupIndex = maxBackupIndex;
    }

    @Override
    protected void writeElements(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeEmptyElement(Element.FILE.getLocalName());
        String relativeTo = this.getRelativeTo();
        if (relativeTo != null) {
            streamWriter.writeAttribute(Attribute.RELATIVE_TO.getLocalName(), relativeTo);
        }
        streamWriter.writeAttribute(Attribute.PATH.getLocalName(), this.getPath());
        streamWriter.writeEmptyElement(Element.ROTATE_SIZE.getLocalName());
        streamWriter.writeAttribute(Attribute.VALUE.getLocalName(), Long.toString(this.rotateSize));
        streamWriter.writeEmptyElement(Element.MAX_BACKUP_INDEX.getLocalName());
        streamWriter.writeAttribute(Attribute.VALUE.getLocalName(), Integer.toString(this.maxBackupIndex));
        super.writeElements(streamWriter);
    }

    @Override
    AbstractHandlerAdd createAdd(String name) {
        SizeRotatingFileHandlerAdd add = new SizeRotatingFileHandlerAdd(name);
        add.setAppend(this.isAppend());
        add.setRelativeTo(this.getRelativeTo());
        add.setPath(this.getPath());
        add.setRotateSize(this.rotateSize);
        add.setMaxBackupIndex(this.maxBackupIndex);
        return add;
    }
}

