/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.logging.Level;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.logging.AbstractFormatterSpec;
import org.jboss.as.logging.ConsoleHandlerService;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.LoggerHandlerType;
import org.jboss.as.logging.PatternFormatterSpec;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

class ConsoleHandlerAdd
implements ModelAddOperationHandler {
    static final ConsoleHandlerAdd INSTANCE = new ConsoleHandlerAdd();
    static final String OPERATION_NAME = "add-console-handler";

    ConsoleHandlerAdd() {
    }

    public OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        final String name = address.getLastElement().getValue();
        ModelNode compensatingOperation = new ModelNode();
        compensatingOperation.get("address").set(operation.require("address"));
        compensatingOperation.get("operation").set("remove");
        String handlerType = operation.require("handler-type").asString();
        LoggerHandlerType type = LoggerHandlerType.valueOf(handlerType);
        if (type != LoggerHandlerType.CONSOLE_HANDLER) {
            throw new OperationFailedException(new ModelNode().set("invalid operation for handler-type: " + (Object)((Object)type)));
        }
        ModelNode subModel = context.getSubModel();
        subModel.get("autoflush").set(operation.get("autoflush"));
        subModel.get("encoding").set(operation.get("encoding"));
        subModel.get("formatter").set(operation.get("formatter"));
        subModel.get("handler-type").set(handlerType);
        subModel.get("level").set(operation.get("level"));
        subModel.get("queue-length").set(operation.get("queue-length"));
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceTarget serviceTarget = context.getServiceTarget();
                    try {
                        ConsoleHandlerService service = new ConsoleHandlerService();
                        ServiceBuilder serviceBuilder = serviceTarget.addService(LogServices.handlerName(name), (Service)service);
                        service.setLevel(Level.parse(operation.get("level").asString()));
                        Boolean autoFlush = operation.get("autoflush").asBoolean();
                        if (autoFlush != null) {
                            service.setAutoflush(autoFlush);
                        }
                        if (operation.hasDefined("encoding")) {
                            service.setEncoding(operation.get("encoding").asString());
                        }
                        if (operation.hasDefined("formatter")) {
                            service.setFormatterSpec(ConsoleHandlerAdd.createFormatterSpec(operation));
                        }
                        serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
                        serviceBuilder.addListener((ServiceListener)new ResultHandler.ServiceStartListener(resultHandler));
                        serviceBuilder.install();
                    }
                    catch (Throwable t) {
                        throw new OperationFailedException(new ModelNode().set(t.getLocalizedMessage()));
                    }
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }

    static AbstractFormatterSpec createFormatterSpec(ModelNode operation) {
        return new PatternFormatterSpec(operation.get("formatter").asString());
    }
}

