/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.as.logging.AbstractFormatterSpec;
import org.jboss.logmanager.handlers.FileHandler;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public final class FileHandlerService
implements Service<Handler> {
    private final InjectedValue<String> relativeTo = new InjectedValue();
    private AbstractFormatterSpec formatterSpec;
    private Level level;
    private boolean autoflush;
    private String encoding;
    private boolean append;
    private String path;
    private FileHandler value;

    public synchronized void start(StartContext context) throws StartException {
        FileHandler handler;
        this.value = handler = new FileHandler();
        this.formatterSpec.apply((Handler)handler);
        if (this.level != null) {
            handler.setLevel(this.level);
        }
        handler.setAutoFlush(this.autoflush);
        try {
            handler.setEncoding(this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new StartException((Throwable)e);
        }
        handler.setAppend(this.append);
        try {
            this.setFileName();
        }
        catch (FileNotFoundException e) {
            throw new StartException((Throwable)e);
        }
        this.value = handler;
    }

    public synchronized void stop(StopContext context) {
        FileHandler handler = this.value;
        handler.close();
        this.value = null;
    }

    public synchronized Handler getValue() throws IllegalStateException {
        return this.value;
    }

    public synchronized Level getLevel() {
        return this.level;
    }

    public synchronized void setLevel(Level level) {
        this.level = level;
        FileHandler handler = this.value;
        if (handler != null) {
            handler.setLevel(level);
        }
    }

    public synchronized AbstractFormatterSpec getFormatterSpec() {
        return this.formatterSpec;
    }

    public synchronized void setFormatterSpec(AbstractFormatterSpec formatterSpec) {
        this.formatterSpec = formatterSpec;
        FileHandler handler = this.value;
        if (handler != null) {
            formatterSpec.apply((Handler)handler);
        }
    }

    public synchronized boolean isAutoflush() {
        return this.autoflush;
    }

    public synchronized void setAutoflush(boolean autoflush) {
        this.autoflush = autoflush;
        FileHandler handler = this.value;
        if (handler != null) {
            handler.setAutoFlush(autoflush);
        }
    }

    public synchronized String getEncoding() {
        return this.encoding;
    }

    public synchronized void setEncoding(String encoding) throws UnsupportedEncodingException {
        FileHandler handler = this.value;
        if (handler != null) {
            handler.setEncoding(encoding);
        }
        this.encoding = encoding;
    }

    public synchronized boolean isAppend() {
        return this.append;
    }

    public synchronized void setAppend(boolean append) {
        this.append = append;
        FileHandler handler = this.value;
        if (handler != null) {
            handler.setAppend(append);
        }
    }

    private void setFileName() throws FileNotFoundException {
        FileHandler handler = this.value;
        if (handler == null) {
            return;
        }
        String value = (String)this.relativeTo.getOptionalValue();
        String fileName = value != null ? value + "/" + this.path : this.path;
        handler.setFileName(fileName);
    }

    public synchronized void setPath(String path) throws FileNotFoundException {
        this.path = path;
        this.setFileName();
    }

    public Injector<String> getRelativeToInjector() {
        return this.relativeTo;
    }
}

