/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.logging.Handler;
import org.jboss.as.logging.LoggerHandlerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public final class LogServices {
    public static final ServiceName JBOSS_LOGGING = ServiceName.JBOSS.append(new String[]{"logging"});
    public static final ServiceName LOGGER = JBOSS_LOGGING.append(new String[]{"logger"});
    public static final ServiceName ROOT_LOGGER = JBOSS_LOGGING.append(new String[]{"root-logger"});
    public static final ServiceName LOGGER_HANDLER = JBOSS_LOGGING.append(new String[]{"logger-handler"});
    public static final ServiceName ROOT_LOGGER_HANDLER = JBOSS_LOGGING.append(new String[]{"root-logger-handler"});
    public static final ServiceName HANDLER = JBOSS_LOGGING.append(new String[]{"handler"});

    private LogServices() {
    }

    public static ServiceName loggerName(String name) {
        return "".equals(name) ? ROOT_LOGGER : LOGGER.append(new String[]{name});
    }

    public static ServiceName loggerHandlerName(String loggerName, String handlerName) {
        return loggerName.length() == 0 ? ROOT_LOGGER_HANDLER.append(new String[]{handlerName}) : LOGGER_HANDLER.append(new String[]{loggerName, handlerName});
    }

    public static ServiceName handlerName(String name) {
        return HANDLER.append(new String[]{name});
    }

    static void installLoggerHandlers(ServiceTarget serviceTarget, String loggerName, ModelNode handlers) {
        for (ModelNode handler : handlers.asList()) {
            String handlerName = handler.asString();
            LoggerHandlerService service = new LoggerHandlerService(loggerName);
            Injector<Handler> injector = service.getHandlerInjector();
            serviceTarget.addService(LogServices.loggerHandlerName(loggerName, handlerName), (Service)service).addDependency(LogServices.loggerName(loggerName)).addDependency(LogServices.handlerName(handlerName), Handler.class, injector).install();
        }
    }

    static void uninstallLoggerHandlers(ServiceRegistry registry, String loggerName, ModelNode handlers) {
        for (ModelNode handler : handlers.asList()) {
            String handlerName = handler.asString();
            ServiceController controller = registry.getService(LogServices.loggerHandlerName(loggerName, handlerName));
            if (controller == null) continue;
            controller.setMode(ServiceController.Mode.REMOVE);
        }
    }
}

