/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.HashMap;
import java.util.Map;

enum LoggerHandlerType {
    UNKNOWN(null),
    ASYNC_HANDLER("async-handler"),
    CONSOLE_HANDLER("console-handler"),
    FILE_HANDLER("file-handler"),
    HANDLER("handler"),
    PERIODIC_ROTATING_FILE_HANDLER("periodic-rotating-file-handler"),
    SIZE_ROTATING_FILE_HANDLER("size-rotating-file-handler");

    private final String name;
    private static final Map<String, LoggerHandlerType> MAP;

    private LoggerHandlerType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static LoggerHandlerType forName(String localName) {
        LoggerHandlerType element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, LoggerHandlerType> map = new HashMap<String, LoggerHandlerType>();
        for (LoggerHandlerType element : LoggerHandlerType.values()) {
            String name = element.getName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

