/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.logging.HandlerFileService;
import org.jboss.as.logging.LogServices;
import org.jboss.as.server.services.path.AbstractPathService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public class HandlerFileChange
implements ModelUpdateOperationHandler {
    static final String OPERATION_NAME = "change-file";
    static final HandlerFileChange INSTANCE = new HandlerFileChange();

    public OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        ModelNode opAddr = operation.require("address");
        ModelNode model = context.getSubModel();
        ModelNode existingFile = model.get("file");
        ModelNode compensatingOperation = new ModelNode();
        compensatingOperation.get("operation").set(OPERATION_NAME);
        compensatingOperation.get("address").set(opAddr);
        compensatingOperation.get("path").set(existingFile.get("path"));
        existingFile.get("path").set(operation.get("path"));
        if (existingFile.hasDefined("relative-to")) {
            compensatingOperation.get("relative-to").set(existingFile.get("relative-to"));
            existingFile.get("relative-to").set(operation.get("relative-to"));
        }
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        final String name = address.getLastElement().getValue();
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceRegistry serviceRegistry = context.getServiceRegistry();
                    final ServiceTarget serviceTarget = context.getServiceTarget();
                    ServiceController controller = serviceRegistry.getService(LogServices.handlerFileName(name));
                    if (controller != null) {
                        controller.addListener((ServiceListener)new AbstractServiceListener<Object>(){

                            public void listenerAdded(ServiceController<?> controller) {
                                controller.setMode(ServiceController.Mode.REMOVE);
                            }

                            public void serviceRemoved(ServiceController<?> controller) {
                                HandlerFileChange.this.installService(operation, serviceTarget, name, resultHandler);
                            }
                        });
                    } else {
                        HandlerFileChange.this.installService(operation, serviceTarget, name, resultHandler);
                    }
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }

    private void installService(ModelNode operation, ServiceTarget serviceTarget, String name, final ResultHandler resultHandler) {
        HandlerFileService service = new HandlerFileService(operation.get("path").asString());
        ServiceBuilder builder = serviceTarget.addService(LogServices.handlerFileName(name), (Service)service);
        if (operation.hasDefined("relative-to")) {
            builder.addDependency(AbstractPathService.pathNameOf((String)operation.get("relative-to").asString()), String.class, service.getRelativeToInjector());
        }
        builder.setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)new AbstractServiceListener<Object>(){

            public void serviceStarted(ServiceController<?> controller) {
                resultHandler.handleResultComplete();
            }
        }).install();
    }
}

