/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.logging.LogServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

public class HandlerLevelChange
implements ModelUpdateOperationHandler {
    static final String OPERATION_NAME = "change-log-level";
    static final HandlerLevelChange INSTANCE = new HandlerLevelChange();

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        ModelNode opAddr = operation.require("address");
        ModelNode model = context.getSubModel();
        ModelNode compensatingOperation = new ModelNode();
        compensatingOperation.get("operation").set(OPERATION_NAME);
        compensatingOperation.get("address").set(opAddr);
        compensatingOperation.get("level").set(model.get("level"));
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        final String name = address.getLastElement().getValue();
        final String level = operation.get("level").asString();
        model.get("level").set(level);
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceRegistry serviceRegistry = context.getServiceRegistry();
                    ServiceController controller = serviceRegistry.getService(LogServices.handlerName(name));
                    if (controller != null) {
                        ((Handler)controller.getValue()).setLevel(Level.parse(level));
                    }
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }
}

