/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.logging.AsyncHandlerAdd;
import org.jboss.as.logging.ConsoleHandlerAdd;
import org.jboss.as.logging.FileHandlerAdd;
import org.jboss.as.logging.LoggerHandlerType;
import org.jboss.as.logging.PeriodicRotatingFileHandlerAdd;
import org.jboss.as.logging.SizeRotatingFileHandlerAdd;
import org.jboss.dmr.ModelNode;

class LoggerHandlerAdd
implements ModelAddOperationHandler {
    static final LoggerHandlerAdd INSTANCE = new LoggerHandlerAdd();

    LoggerHandlerAdd() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        String handlerType = operation.require("handler-type").asString();
        LoggerHandlerType type = LoggerHandlerType.valueOf(handlerType);
        switch (type) {
            case ASYNC_HANDLER: {
                return AsyncHandlerAdd.INSTANCE.execute(context, operation, resultHandler);
            }
            case CONSOLE_HANDLER: {
                return ConsoleHandlerAdd.INSTANCE.execute(context, operation, resultHandler);
            }
            case FILE_HANDLER: {
                return FileHandlerAdd.INSTANCE.execute(context, operation, resultHandler);
            }
            case PERIODIC_ROTATING_FILE_HANDLER: {
                return PeriodicRotatingFileHandlerAdd.INSTANCE.execute(context, operation, resultHandler);
            }
            case SIZE_ROTATING_FILE_HANDLER: {
                return SizeRotatingFileHandlerAdd.INSTANCE.execute(context, operation, resultHandler);
            }
        }
        throw new OperationFailedException(new ModelNode().set("unknown log handler type"));
    }
}

