/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.logging.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class LoggingSubsystemProviders {
    static final String RESOURCE_NAME = LoggingSubsystemProviders.class.getPackage().getName() + ".LocalDescriptions";
    static final DescriptionProvider SUBSYSTEM = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("description").set(bundle.getString("logging"));
            subsystem.get("head-comment-allowed").set(true);
            subsystem.get("tail-comment-allowed").set(true);
            subsystem.get("namespace").set(Namespace.CURRENT.getUriString());
            subsystem.get("operations");
            subsystem.get(new String[]{"children", "root-logger", "description"}).set(bundle.getString("root.logger"));
            subsystem.get(new String[]{"children", "async-handler", "description"}).set(bundle.getString("async.handler"));
            subsystem.get(new String[]{"children", "console-handler", "description"}).set(bundle.getString("console.handler"));
            subsystem.get(new String[]{"children", "file-handler", "description"}).set(bundle.getString("file.handler"));
            subsystem.get(new String[]{"children", "periodic-rotating-file-handler", "description"}).set(bundle.getString("periodic.handler"));
            subsystem.get(new String[]{"children", "size-rotating-file-handler", "description"}).set(bundle.getString("size.periodic.handler"));
            return subsystem;
        }
    };
    static final DescriptionProvider SUBSYSTEM_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle.getString("logging.add"));
            operation.get("request-properties").setEmptyObject();
            operation.get("reply-properties").setEmptyObject();
            return operation;
        }
    };
    static final DescriptionProvider SET_ROOT_LOGGER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("set-root-logger");
            node.get("description").set(bundle.getString("root.logger.set"));
            node.get(new String[]{"request-properties", "level", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "level", "description"}).set(bundle.getString("logger.level"));
            node.get(new String[]{"request-properties", "level", "required"}).set(true);
            node.get(new String[]{"request-properties", "handlers", "type"}).set(ModelType.LIST);
            node.get(new String[]{"request-properties", "handlers", "value-type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "handlers", "description"}).set(bundle.getString("logger.handlers"));
            node.get(new String[]{"request-properties", "handlers", "required"}).set(true);
            node.get("reply-properties").setEmptyObject();
            return node;
        }
    };
    static final DescriptionProvider REMOVE_ROOT_LOGGER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("remove-root-logger");
            operation.get("description").set(bundle.getString("root.logger.remove"));
            operation.get("request-properties").setEmptyObject();
            operation.get("reply-properties").setEmptyObject();
            return operation;
        }
    };
    static final DescriptionProvider ROOT_LOGGER_CHANGE_LEVEL = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("change-root-log-level");
            operation.get("description").set(bundle.getString("root.logger.change-level"));
            operation.get(new String[]{"request-properties", "level", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "level", "description"}).set(bundle.getString("logger.level"));
            operation.get(new String[]{"request-properties", "level", "required"}).set(true);
            return operation;
        }
    };
    static final DescriptionProvider LOGGER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle.getString("logger"));
            return node;
        }
    };
    static final DescriptionProvider LOGGER_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("add");
            node.get("description").set(bundle.getString("logger.add"));
            node.get(new String[]{"request-properties", "level", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "level", "description"}).set(bundle.getString("logger.level"));
            node.get(new String[]{"request-properties", "level", "required"}).set(true);
            node.get(new String[]{"request-properties", "handlers", "type"}).set(ModelType.LIST);
            node.get(new String[]{"request-properties", "handlers", "value-type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "handlers", "description"}).set(bundle.getString("logger.handlers"));
            node.get(new String[]{"request-properties", "handlers", "required"}).set(false);
            node.get(new String[]{"request-properties", "encoding", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "encoding", "description"}).set(bundle.getString("logger.level"));
            node.get(new String[]{"request-properties", "encoding", "required"}).set(true);
            return node;
        }
    };
    static final DescriptionProvider LOGGER_REMOVE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("remove");
            node.get("description").set(bundle.getString("logger.remove"));
            node.get("request-properties").setEmptyObject();
            node.get("reply-properties").setEmptyObject();
            return node;
        }
    };
    static final DescriptionProvider LOGGER_CHANGE_LEVEL = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("change-log-level");
            node.get("description").set(bundle.getString("logger.change-level"));
            node.get(new String[]{"request-properties", "level", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "level", "description"}).set(bundle.getString("logger.level"));
            node.get(new String[]{"request-properties", "level", "required"}).set(true);
            return node;
        }
    };
    static final DescriptionProvider HANDLER_REMOVE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle.getString("handler.remove"));
            return node;
        }
    };
    static final DescriptionProvider ASYNC_HANDLER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle.getString("async.handler"));
            LoggingSubsystemProviders.addCommonHandlerAttributes(node, bundle);
            node.get(new String[]{"attributes", "handler", "type"}).set(ModelType.LIST);
            node.get(new String[]{"attributes", "handler", "value-type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "handler", "description"}).set(bundle.getString("logger.handlers"));
            node.get(new String[]{"attributes", "queue-length", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "queue-length", "description"}).set(bundle.getString("async.queue-length"));
            node.get(new String[]{"attributes", "overflow-action", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "overflow-action", "description"}).set(bundle.getString("async.overflow-action"));
            return node;
        }
    };
    static final DescriptionProvider ASYNC_HANDLER_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle.getString("async.handler.add"));
            LoggingSubsystemProviders.addCommonHandlerRequestProperties(operation, bundle);
            operation.get(new String[]{"request-properties", "queue-length", "type"}).set(ModelType.INT);
            operation.get(new String[]{"request-properties", "queue-length", "description"}).set(bundle.getString("async.queue-length"));
            operation.get(new String[]{"request-properties", "queue-length", "required"}).set(true);
            return operation;
        }
    };
    static final DescriptionProvider ASYNC_HANDLER_UPDATE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("update-properties");
            operation.get("description").set(bundle.getString("async.handler.update"));
            LoggingSubsystemProviders.addCommonHandlerUpdateRequestProperties(operation, bundle);
            operation.get(new String[]{"request-properties", "queue-length", "type"}).set(ModelType.INT);
            operation.get(new String[]{"request-properties", "queue-length", "description"}).set(bundle.getString("async.queue-length"));
            operation.get(new String[]{"request-properties", "queue-length", "required"}).set(true);
            return operation;
        }
    };
    static final DescriptionProvider CONSOLE_HANDLER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle.getString("console.handler"));
            LoggingSubsystemProviders.addCommonHandlerAttributes(node, bundle);
            node.get(new String[]{"attributes", "target", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "target", "description"}).set(bundle.getString("console.handler.target"));
            return node;
        }
    };
    static final DescriptionProvider CONSOLE_HANDLER_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle.getString("console.handler"));
            LoggingSubsystemProviders.addCommonHandlerRequestProperties(operation, bundle);
            operation.get(new String[]{"request-properties", "target", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "target", "description"}).set(bundle.getString("console.handler.target"));
            operation.get(new String[]{"request-properties", "target", "required"}).set(true);
            return operation;
        }
    };
    static final DescriptionProvider CONSOLE_HANDLER_UPDATE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("update-properties");
            operation.get("description").set(bundle.getString("console.handler.update"));
            LoggingSubsystemProviders.addCommonHandlerUpdateRequestProperties(operation, bundle);
            operation.get(new String[]{"request-properties", "target", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "target", "description"}).set(bundle.getString("console.handler.target"));
            operation.get(new String[]{"request-properties", "target", "required"}).set(true);
            return operation;
        }
    };
    static final DescriptionProvider FILE_HANDLER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle.getString("file.handler"));
            LoggingSubsystemProviders.addCommonFileHandlerAttributes(node, bundle);
            return node;
        }
    };
    static final DescriptionProvider FILE_HANDLER_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle.getString("file.handler"));
            LoggingSubsystemProviders.addCommonFileHandlerRequestProperties(operation, bundle);
            return operation;
        }
    };
    static final DescriptionProvider FILE_HANDLER_UPDATE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("update-properties");
            operation.get("description").set(bundle.getString("file.handler.update"));
            LoggingSubsystemProviders.addCommonFileHandlerUpdateRequestProperties(operation, bundle);
            return operation;
        }
    };
    static final DescriptionProvider PERIODIC_HANDLER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle.getString("periodic.handler"));
            LoggingSubsystemProviders.addCommonFileHandlerAttributes(node, bundle);
            node.get(new String[]{"attributes", "suffix", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "suffix", "description"}).set(bundle.getString("periodic.handler.suffix"));
            return node;
        }
    };
    static final DescriptionProvider PERIODIC_HANDLER_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle.getString("periodic.handler"));
            LoggingSubsystemProviders.addCommonFileHandlerRequestProperties(operation, bundle);
            operation.get(new String[]{"request-properties", "suffix", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "suffix", "description"}).set(bundle.getString("periodic.handler.suffix"));
            operation.get(new String[]{"request-properties", "suffix", "required"}).set(true);
            return operation;
        }
    };
    static final DescriptionProvider PERIODIC_HANDLER_UPDATE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("update-properties");
            operation.get("description").set(bundle.getString("periodic.handler.update"));
            LoggingSubsystemProviders.addCommonFileHandlerUpdateRequestProperties(operation, bundle);
            operation.get(new String[]{"request-properties", "suffix", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "suffix", "description"}).set(bundle.getString("periodic.handler.suffix"));
            operation.get(new String[]{"request-properties", "suffix", "required"}).set(true);
            return operation;
        }
    };
    static final DescriptionProvider SIZE_PERIODIC_HANDLER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle.getString("size.periodic.handler"));
            LoggingSubsystemProviders.addCommonFileHandlerAttributes(node, bundle);
            node.get(new String[]{"attributes", "rotate-size", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "rotate-size", "description"}).set(bundle.getString("size.periodic.handler.rotate-size"));
            node.get(new String[]{"attributes", "max-backup-index", "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", "max-backup-index", "description"}).set(bundle.getString("size.periodic.handler.max-backup"));
            return node;
        }
    };
    static final DescriptionProvider SIZE_PERIODIC_HANDLER_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle.getString("size.periodic.handler.add"));
            LoggingSubsystemProviders.addCommonFileHandlerRequestProperties(operation, bundle);
            operation.get(new String[]{"request-properties", "rotate-size", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "rotate-size", "description"}).set(bundle.getString("size.periodic.handler.rotate-size"));
            operation.get(new String[]{"request-properties", "rotate-size", "required"}).set(true);
            operation.get(new String[]{"request-properties", "max-backup-index", "type"}).set(ModelType.INT);
            operation.get(new String[]{"request-properties", "max-backup-index", "description"}).set(bundle.getString("size.periodic.handler.max-backup"));
            operation.get(new String[]{"request-properties", "max-backup-index", "required"}).set(true);
            return operation;
        }
    };
    static final DescriptionProvider SIZE_PERIODIC_HANDLER_UPDATE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("update-properties");
            operation.get("description").set(bundle.getString("size.periodic.handler.update"));
            LoggingSubsystemProviders.addCommonFileHandlerUpdateRequestProperties(operation, bundle);
            operation.get(new String[]{"request-properties", "rotate-size", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "rotate-size", "description"}).set(bundle.getString("size.periodic.handler.rotate-size"));
            operation.get(new String[]{"request-properties", "rotate-size", "required"}).set(true);
            operation.get(new String[]{"request-properties", "max-backup-index", "type"}).set(ModelType.INT);
            operation.get(new String[]{"request-properties", "max-backup-index", "description"}).set(bundle.getString("size.periodic.handler.max-backup"));
            operation.get(new String[]{"request-properties", "max-backup-index", "required"}).set(true);
            return operation;
        }
    };
    static final DescriptionProvider HANDLER_ENABLE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle.getString("handler.enable"));
            return node;
        }
    };
    static final DescriptionProvider HANDLER_DISABLE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle.getString("handler.disable"));
            return node;
        }
    };
    static final DescriptionProvider HANDLER_CHANGE_LEVEL = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("change-log-level");
            node.get("description").set(bundle.getString("handler.change-level"));
            node.get(new String[]{"request-properties", "level", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "level", "description"}).set(bundle.getString("logger.level"));
            node.get(new String[]{"request-properties", "level", "required"}).set(true);
            return node;
        }
    };
    static final DescriptionProvider HANDLER_CHANGE_FILE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("change-file");
            node.get("description").set(bundle.getString("handler.change-file"));
            node.get(new String[]{"request-properties", "path", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "path", "description"}).set(bundle.getString("file.handler.path"));
            node.get(new String[]{"request-properties", "path", "required"}).set(true);
            node.get(new String[]{"request-properties", "relative-to", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "relative-to", "description"}).set(bundle.getString("file.handler.relative-to"));
            node.get(new String[]{"request-properties", "relative-to", "required"}).set(false);
            return node;
        }
    };

    LoggingSubsystemProviders() {
    }

    private static void addCommonHandlerAttributes(ModelNode modelNode, ResourceBundle bundle) {
        modelNode.get(new String[]{"attributes", "name", "type"}).set(ModelType.STRING);
        modelNode.get(new String[]{"attributes", "name", "description"}).set(bundle.getString("handler.name"));
        modelNode.get(new String[]{"attributes", "level", "type"}).set(ModelType.STRING);
        modelNode.get(new String[]{"attributes", "level", "description"}).set(bundle.getString("handler.level"));
        modelNode.get(new String[]{"attributes", "encoding", "type"}).set(ModelType.STRING);
        modelNode.get(new String[]{"attributes", "encoding", "description"}).set(bundle.getString("handler.encoding"));
        modelNode.get(new String[]{"attributes", "filter", "type"}).set(ModelType.STRING);
        modelNode.get(new String[]{"attributes", "filter", "description"}).set(bundle.getString("handler.filter"));
        modelNode.get(new String[]{"attributes", "formatter", "type"}).set(ModelType.STRING);
        modelNode.get(new String[]{"attributes", "formatter", "description"}).set(bundle.getString("handler.formatter"));
        modelNode.get(new String[]{"attributes", "autoflush", "type"}).set(ModelType.BOOLEAN);
        modelNode.get(new String[]{"attributes", "autoflush", "description"}).set(bundle.getString("handler.autoflush"));
    }

    private static void addCommonHandlerRequestProperties(ModelNode modelNode, ResourceBundle bundle) {
        modelNode.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
        modelNode.get(new String[]{"request-properties", "name", "description"}).set(bundle.getString("handler.name"));
        modelNode.get(new String[]{"request-properties", "name", "required"}).set(true);
        modelNode.get(new String[]{"request-properties", "level", "type"}).set(ModelType.STRING);
        modelNode.get(new String[]{"request-properties", "level", "description"}).set(bundle.getString("handler.level"));
        modelNode.get(new String[]{"request-properties", "level", "required"}).set(true);
        modelNode.get(new String[]{"request-properties", "encoding", "type"}).set(ModelType.STRING);
        modelNode.get(new String[]{"request-properties", "encoding", "description"}).set(bundle.getString("handler.encoding"));
        modelNode.get(new String[]{"request-properties", "encoding", "required"}).set(true);
        modelNode.get(new String[]{"request-properties", "filter", "type"}).set(ModelType.STRING);
        modelNode.get(new String[]{"request-properties", "filter", "description"}).set(bundle.getString("handler.filter"));
        modelNode.get(new String[]{"request-properties", "filter", "required"}).set(false);
        modelNode.get(new String[]{"request-properties", "formatter", "type"}).set(ModelType.STRING);
        modelNode.get(new String[]{"request-properties", "formatter", "description"}).set(bundle.getString("handler.formatter"));
        modelNode.get(new String[]{"request-properties", "formatter", "required"}).set(true);
        modelNode.get(new String[]{"request-properties", "autoflush", "type"}).set(ModelType.BOOLEAN);
        modelNode.get(new String[]{"request-properties", "autoflush", "description"}).set(bundle.getString("handler.autoflush"));
        modelNode.get(new String[]{"request-properties", "autoflush", "required"}).set(false);
    }

    private static void addCommonHandlerUpdateRequestProperties(ModelNode modelNode, ResourceBundle bundle) {
        modelNode.get(new String[]{"request-properties", "level", "type"}).set(ModelType.STRING);
        modelNode.get(new String[]{"request-properties", "level", "description"}).set(bundle.getString("handler.level"));
        modelNode.get(new String[]{"request-properties", "level", "required"}).set(true);
        modelNode.get(new String[]{"request-properties", "encoding", "type"}).set(ModelType.STRING);
        modelNode.get(new String[]{"request-properties", "encoding", "description"}).set(bundle.getString("handler.encoding"));
        modelNode.get(new String[]{"request-properties", "encoding", "required"}).set(true);
        modelNode.get(new String[]{"request-properties", "filter", "type"}).set(ModelType.STRING);
        modelNode.get(new String[]{"request-properties", "filter", "description"}).set(bundle.getString("handler.filter"));
        modelNode.get(new String[]{"request-properties", "filter", "required"}).set(false);
        modelNode.get(new String[]{"request-properties", "formatter", "type"}).set(ModelType.STRING);
        modelNode.get(new String[]{"request-properties", "formatter", "description"}).set(bundle.getString("handler.formatter"));
        modelNode.get(new String[]{"request-properties", "formatter", "required"}).set(true);
        modelNode.get(new String[]{"request-properties", "autoflush", "type"}).set(ModelType.BOOLEAN);
        modelNode.get(new String[]{"request-properties", "autoflush", "description"}).set(bundle.getString("handler.autoflush"));
        modelNode.get(new String[]{"request-properties", "autoflush", "required"}).set(false);
    }

    private static void addCommonFileHandlerAttributes(ModelNode model, ResourceBundle bundle) {
        LoggingSubsystemProviders.addCommonHandlerAttributes(model, bundle);
        model.get(new String[]{"attributes", "append", "type"}).set(ModelType.BOOLEAN);
        model.get(new String[]{"attributes", "append", "description"}).set(bundle.getString("file.handler.append"));
        model.get(new String[]{"attributes", "file", "relative-to", "type"}).set(ModelType.STRING);
        model.get(new String[]{"attributes", "file", "relative-to", "description"}).set(bundle.getString("file.handler.relative-to"));
        model.get(new String[]{"attributes", "file", "path", "type"}).set(ModelType.STRING);
        model.get(new String[]{"attributes", "file", "path", "description"}).set(bundle.getString("file.handler.path"));
    }

    private static void addCommonFileHandlerRequestProperties(ModelNode model, ResourceBundle bundle) {
        LoggingSubsystemProviders.addCommonHandlerRequestProperties(model, bundle);
        model.get(new String[]{"request-properties", "append", "type"}).set(ModelType.BOOLEAN);
        model.get(new String[]{"request-properties", "append", "description"}).set(bundle.getString("file.handler.append"));
        model.get(new String[]{"request-properties", "append", "required"}).set(false);
        model.get(new String[]{"request-properties", "file", "relative-to", "type"}).set(ModelType.STRING);
        model.get(new String[]{"request-properties", "file", "relative-to", "description"}).set(bundle.getString("file.handler.relative-to"));
        model.get(new String[]{"request-properties", "file", "relative-to", "required"}).set(false);
        model.get(new String[]{"request-properties", "file", "path", "type"}).set(ModelType.STRING);
        model.get(new String[]{"request-properties", "file", "path", "description"}).set(bundle.getString("file.handler.path"));
        model.get(new String[]{"request-properties", "file", "path", "required"}).set(true);
    }

    private static void addCommonFileHandlerUpdateRequestProperties(ModelNode model, ResourceBundle bundle) {
        LoggingSubsystemProviders.addCommonHandlerUpdateRequestProperties(model, bundle);
        model.get(new String[]{"request-properties", "append", "type"}).set(ModelType.BOOLEAN);
        model.get(new String[]{"request-properties", "append", "description"}).set(bundle.getString("file.handler.append"));
        model.get(new String[]{"request-properties", "append", "required"}).set(false);
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

