/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.logging.AsyncHandlerService;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.OverflowAction;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;

class AsyncHandlerAdd
extends AbstractAddStepHandler {
    static final AsyncHandlerAdd INSTANCE = new AsyncHandlerAdd();

    AsyncHandlerAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        model.get("queue-length").set(operation.get("queue-length"));
        model.get("subhandlers").set(operation.get("subhandlers"));
        model.get("level").set(operation.get("level"));
        model.get("overflow-action").set(operation.get("overflow-action"));
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        ServiceTarget serviceTarget = context.getServiceTarget();
        AsyncHandlerService service = new AsyncHandlerService();
        ServiceBuilder serviceBuilder = serviceTarget.addService(LogServices.handlerName(name), (Service)service);
        ArrayList<InjectedValue<Handler>> list = new ArrayList<InjectedValue<Handler>>();
        for (ModelNode handlerName : operation.get("subhandlers").asList()) {
            InjectedValue injectedValue = new InjectedValue();
            serviceBuilder.addDependency(LogServices.handlerName(handlerName.asString()), Handler.class, (Injector)injectedValue);
            list.add((InjectedValue<Handler>)injectedValue);
        }
        service.addHandlers(list);
        if (operation.hasDefined("queue-length")) {
            service.setQueueLength(operation.get("queue-length").asInt());
        }
        service.setLevel(Level.parse(operation.get("level").asString()));
        service.setOverflowAction(OverflowAction.valueOf(operation.get("overflow-action").asString()));
        serviceBuilder.addListener((ServiceListener)verificationHandler);
        serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        newControllers.add(serviceBuilder.install());
    }
}

