/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Handler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.logging.LoggerHandlerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public final class LogServices {
    public static final ServiceName JBOSS_LOGGING = ServiceName.JBOSS.append(new String[]{"logging"});
    public static final ServiceName LOGGER = JBOSS_LOGGING.append(new String[]{"logger"});
    public static final ServiceName ROOT_LOGGER = JBOSS_LOGGING.append(new String[]{"root-logger"});
    public static final ServiceName LOGGER_HANDLER = JBOSS_LOGGING.append(new String[]{"logger-handler"});
    public static final ServiceName ROOT_LOGGER_HANDLER = JBOSS_LOGGING.append(new String[]{"root-logger-handler"});
    public static final ServiceName HANDLER = JBOSS_LOGGING.append(new String[]{"handler"});
    public static final ServiceName HANDLER_FILE = JBOSS_LOGGING.append(new String[]{"handler-file"});

    private LogServices() {
    }

    public static ServiceName loggerName(String name) {
        return "".equals(name) ? ROOT_LOGGER : LOGGER.append(new String[]{name});
    }

    public static ServiceName loggerHandlerName(String loggerName, String handlerName) {
        return loggerName.length() == 0 ? ROOT_LOGGER_HANDLER.append(new String[]{handlerName}) : LOGGER_HANDLER.append(new String[]{loggerName, handlerName});
    }

    public static ServiceName handlerName(String name) {
        return HANDLER.append(new String[]{name});
    }

    public static ServiceName handlerFileName(String handlerName) {
        return HANDLER_FILE.append(new String[]{handlerName});
    }

    static Collection<ServiceController<?>> installLoggerHandlers(ServiceTarget serviceTarget, String loggerName, ModelNode handlers, ServiceVerificationHandler verificationHandler) {
        ArrayList controllers = new ArrayList();
        for (ModelNode handler : handlers.asList()) {
            String handlerName = handler.asString();
            LoggerHandlerService service = new LoggerHandlerService(loggerName);
            Injector<Handler> injector = service.getHandlerInjector();
            controllers.add(serviceTarget.addService(LogServices.loggerHandlerName(loggerName, handlerName), (Service)service).addDependency(LogServices.loggerName(loggerName)).addDependency(LogServices.handlerName(handlerName), Handler.class, injector).addListener((ServiceListener)verificationHandler).install());
        }
        return controllers;
    }

    static void uninstallLoggerHandlers(OperationContext context, String loggerName, ModelNode handlers) {
        for (ModelNode handler : handlers.asList()) {
            String handlerName = handler.asString();
            context.removeService(LogServices.loggerHandlerName(loggerName, handlerName));
        }
    }
}

