/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.logging.Attribute;
import org.jboss.as.logging.Element;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.Namespace;
import org.jboss.as.logging.OverflowAction;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class LoggingSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    private static final LoggingSubsystemParser INSTANCE = new LoggingSubsystemParser();
    private static final Pattern SIZE_PATTERN = Pattern.compile("(\\d+)([kKmMgGbBtT])?");

    public static LoggingSubsystemParser getInstance() {
        return INSTANCE;
    }

    private LoggingSubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        ModelNode address = new ModelNode();
        address.add("subsystem", "logging");
        address.protect();
        list.add(LoggingExtension.NewLoggingSubsystemAdd.createOperation(address));
        HashSet<String> loggerNames = new HashSet<String>();
        HashSet<String> handlerNames = new HashSet<String>();
        boolean gotRoot = false;
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case LOGGING_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case LOGGER: {
                            LoggingSubsystemParser.parseLoggerElement(reader, address, list, loggerNames);
                            continue block12;
                        }
                        case ROOT_LOGGER: {
                            if (gotRoot) {
                                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                            }
                            gotRoot = true;
                            LoggingSubsystemParser.parseRootLoggerElement(reader, address, list);
                            continue block12;
                        }
                        case CONSOLE_HANDLER: {
                            LoggingSubsystemParser.parseConsoleHandlerElement(reader, address, list, handlerNames);
                            continue block12;
                        }
                        case FILE_HANDLER: {
                            LoggingSubsystemParser.parseFileHandlerElement(reader, address, list, handlerNames);
                            continue block12;
                        }
                        case PERIODIC_ROTATING_FILE_HANDLER: {
                            LoggingSubsystemParser.parsePeriodicRotatingFileHandlerElement(reader, address, list, handlerNames);
                            continue block12;
                        }
                        case SIZE_ROTATING_FILE_HANDLER: {
                            LoggingSubsystemParser.parseSizeRotatingHandlerElement(reader, address, list, handlerNames);
                            continue block12;
                        }
                        case ASYNC_HANDLER: {
                            LoggingSubsystemParser.parseAsyncHandlerElement(reader, address, list, handlerNames);
                            continue block12;
                        }
                    }
                    reader.handleAny(list);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void parseLoggerElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, Set<String> names) throws XMLStreamException {
        String name = null;
        boolean useParentHandlers = true;
        EnumSet<Attribute> required = EnumSet.of(Attribute.CATEGORY);
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case CATEGORY: {
                    name = value;
                    continue block11;
                }
                case USE_PARENT_HANDLERS: {
                    useParentHandlers = Boolean.parseBoolean(value);
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        assert (name != null);
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        String level = null;
        ModelNode handlers = null;
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case LOGGING_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (!encountered.add(element)) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)reader.getLocalName());
                    }
                    switch (element) {
                        case LEVEL: {
                            level = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                            continue block12;
                        }
                        case HANDLERS: {
                            handlers = LoggingSubsystemParser.parseHandlersElement(reader);
                            continue block12;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode node = new ModelNode();
        node.get("operation").set("add");
        node.get("address").set(address).add("logger", name);
        node.get("use-parent-handlers").set(useParentHandlers);
        node.get("level").set(level);
        if (handlers != null) {
            node.get("handlers").set(handlers);
        }
        list.add(node);
    }

    static void parseAsyncHandlerElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, Set<String> names) throws XMLStreamException {
        String name = null;
        boolean autoflush = true;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        String levelName = null;
        ModelNode subhandlers = null;
        int queueLength = 0;
        OverflowAction overflowAction = OverflowAction.BLOCK;
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block10: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case LEVEL: {
                    levelName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                    continue block10;
                }
                case SUBHANDLERS: {
                    subhandlers = LoggingSubsystemParser.parseHandlersElement(reader);
                    continue block10;
                }
                case QUEUE_LENGTH: {
                    queueLength = Integer.parseInt(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                    continue block10;
                }
                case OVERFLOW_ACTION: {
                    overflowAction = OverflowAction.valueOf(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value").toUpperCase(Locale.US));
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode node = new ModelNode();
        node.get("operation").set("add");
        node.get("address").set(address).add("async-handler", name);
        node.get("level").set(levelName);
        if (subhandlers != null) {
            node.get("subhandlers").set(subhandlers);
        }
        node.get("autoflush").set(Boolean.valueOf(autoflush).booleanValue());
        node.get("queue-length").set(queueLength);
        node.get("overflow-action").set(overflowAction.toString());
        list.add(node);
    }

    static void parseRootLoggerElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        String level = null;
        ModelNode handlers = null;
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case LOGGING_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (encountered.contains((Object)element)) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)reader.getLocalName());
                    }
                    encountered.add(element);
                    switch (element) {
                        case LEVEL: {
                            level = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                            continue block7;
                        }
                        case HANDLERS: {
                            handlers = LoggingSubsystemParser.parseHandlersElement(reader);
                            continue block7;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode node = new ModelNode();
        node.get("operation").set("set-root-logger");
        node.get("address").set(address);
        node.get("level").set(level);
        if (handlers != null) {
            node.get("handlers").set(handlers);
        }
        list.add(node);
    }

    static void parseConsoleHandlerElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, Set<String> names) throws XMLStreamException {
        String name = null;
        boolean autoflush = true;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block10;
                }
                case AUTOFLUSH: {
                    autoflush = Boolean.parseBoolean(value);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        String levelName = null;
        String encoding = null;
        String formatterSpec = null;
        String target = null;
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block11: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case LEVEL: {
                    levelName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                    continue block11;
                }
                case ENCODING: {
                    encoding = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value");
                    continue block11;
                }
                case FORMATTER: {
                    formatterSpec = LoggingSubsystemParser.parseFormatterElement(reader);
                    continue block11;
                }
                case TARGET: {
                    target = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                    if (target.equals("System.out") || target.equals("System.err")) continue block11;
                    throw new XMLStreamException("Invalid value for target name", reader.getLocation());
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode node = new ModelNode();
        node.get("operation").set("add");
        node.get("address").set(address).add("console-handler", name);
        node.get("autoflush").set(autoflush);
        node.get("level").set(levelName);
        if (formatterSpec != null) {
            node.get("formatter").set(formatterSpec);
        }
        if (encoding != null) {
            node.get("encoding").set(encoding);
        }
        list.add(node);
    }

    static void parseFileHandlerElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, Set<String> names) throws XMLStreamException {
        String name = null;
        boolean autoflush = true;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block11;
                }
                case AUTOFLUSH: {
                    autoflush = Boolean.parseBoolean(value);
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        String levelName = null;
        String encoding = null;
        ModelNode fileSpec = null;
        boolean append = true;
        String formatterSpec = null;
        EnumSet<Element> requiredElem = EnumSet.of(Element.FILE);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block12: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case LEVEL: {
                    levelName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                    continue block12;
                }
                case ENCODING: {
                    encoding = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value");
                    continue block12;
                }
                case FORMATTER: {
                    formatterSpec = LoggingSubsystemParser.parseFormatterElement(reader);
                    continue block12;
                }
                case FILE: {
                    fileSpec = LoggingSubsystemParser.parseFileElement(reader);
                    continue block12;
                }
                case APPEND: {
                    append = Boolean.parseBoolean(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!requiredElem.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ModelNode node = new ModelNode();
        node.get("operation").set("add");
        node.get("address").set(address).add("file-handler", name);
        node.get("autoflush").set(autoflush);
        node.get("level").set(levelName);
        if (encoding != null) {
            node.get("encoding").set(encoding);
        }
        if (formatterSpec != null) {
            node.get("formatter").set(formatterSpec);
        }
        node.get("file").set(fileSpec);
        node.get("append").set(append);
        list.add(node);
    }

    static void parsePeriodicRotatingFileHandlerElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, Set<String> names) throws XMLStreamException {
        String name = null;
        boolean autoflush = true;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block12;
                }
                case AUTOFLUSH: {
                    autoflush = Boolean.parseBoolean(value);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        String levelName = null;
        String encoding = null;
        String suffix = null;
        ModelNode fileSpec = null;
        boolean append = true;
        String formatterSpec = null;
        EnumSet<Element> requiredElem = EnumSet.of(Element.FILE, Element.SUFFIX);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block13: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case LEVEL: {
                    levelName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                    continue block13;
                }
                case ENCODING: {
                    encoding = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value");
                    continue block13;
                }
                case FORMATTER: {
                    formatterSpec = LoggingSubsystemParser.parseFormatterElement(reader);
                    continue block13;
                }
                case FILE: {
                    fileSpec = LoggingSubsystemParser.parseFileElement(reader);
                    continue block13;
                }
                case APPEND: {
                    append = Boolean.parseBoolean(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                    continue block13;
                }
                case SUFFIX: {
                    suffix = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value");
                    continue block13;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!requiredElem.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ModelNode node = new ModelNode();
        node.get("operation").set("add");
        node.get("address").set(address).add("periodic-rotating-file-handler", name);
        node.get("autoflush").set(autoflush);
        node.get("level").set(levelName);
        if (encoding != null) {
            node.get("encoding").set(encoding);
        }
        if (formatterSpec != null) {
            node.get("formatter").set(formatterSpec);
        }
        node.get("file").set(fileSpec);
        node.get("append").set(append);
        if (suffix != null) {
            node.get("suffix").set(suffix);
        }
        list.add(node);
    }

    static void parseSizeRotatingHandlerElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, Set<String> names) throws XMLStreamException {
        String name = null;
        boolean autoflush = true;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block15: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block15;
                }
                case AUTOFLUSH: {
                    autoflush = Boolean.parseBoolean(value);
                    continue block15;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        String levelName = null;
        String encoding = null;
        ModelNode fileSpec = null;
        boolean append = true;
        long rotateSize = 0L;
        int maxBackupIndex = 1;
        String formatterSpec = null;
        EnumSet<Element> requiredElem = EnumSet.of(Element.FILE);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block16: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case LEVEL: {
                    levelName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                    continue block16;
                }
                case ENCODING: {
                    encoding = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value");
                    continue block16;
                }
                case FORMATTER: {
                    formatterSpec = LoggingSubsystemParser.parseFormatterElement(reader);
                    continue block16;
                }
                case FILE: {
                    fileSpec = LoggingSubsystemParser.parseFileElement(reader);
                    continue block16;
                }
                case APPEND: {
                    append = Boolean.parseBoolean(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                    continue block16;
                }
                case ROTATE_SIZE: {
                    rotateSize = LoggingSubsystemParser.parseSize(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                    continue block16;
                }
                case MAX_BACKUP_INDEX: {
                    try {
                        maxBackupIndex = Integer.parseInt(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                        continue block16;
                    }
                    catch (NumberFormatException e) {
                        throw new XMLStreamException(e.getMessage(), reader.getLocation(), e);
                    }
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!requiredElem.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ModelNode node = new ModelNode();
        node.get("operation").set("add");
        node.get("address").set(address).add("size-rotating-file-handler", name);
        node.get("autoflush").set(autoflush);
        node.get("level").set(levelName);
        if (encoding != null) {
            node.get("encoding").set(encoding);
        }
        if (formatterSpec != null) {
            node.get("formatter").set(formatterSpec);
        }
        node.get("file").set(fileSpec);
        node.get("append").set(append);
        if (rotateSize > 0L) {
            node.get("rotate-size").set(rotateSize);
        }
        if (maxBackupIndex > 0) {
            node.get("max-backup-index").set(maxBackupIndex);
        }
        list.add(node);
    }

    private static long parseSize(String value) {
        Matcher matcher = SIZE_PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new IllegalArgumentException();
        }
        long qty = Long.parseLong(matcher.group(1), 10);
        String chr = matcher.group(2);
        if (chr != null) {
            switch (chr.charAt(0)) {
                case 'B': 
                case 'b': {
                    break;
                }
                case 'K': 
                case 'k': {
                    qty <<= 10;
                    break;
                }
                case 'M': 
                case 'm': {
                    qty <<= 20;
                    break;
                }
                case 'G': 
                case 'g': {
                    qty <<= 30;
                    break;
                }
                case 'T': 
                case 't': {
                    qty <<= 40;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return qty;
    }

    private static ModelNode parseFileElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        String path = null;
        String relativeTo = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATH: {
                    path = value;
                    continue block4;
                }
                case RELATIVE_TO: {
                    relativeTo = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        ModelNode node = new ModelNode();
        if (path != null) {
            node.get("path").set(path);
        }
        if (relativeTo != null) {
            node.get("relative-to").set(relativeTo);
        }
        return node;
    }

    private static String parseFormatterElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        String formatterSpec = null;
        if (reader.nextTag() != 1) {
            throw new XMLStreamException("Missing required nested filter element", reader.getLocation());
        }
        block0 : switch (Namespace.forUri(reader.getNamespaceURI())) {
            case LOGGING_1_0: {
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case PATTERN_FORMATTER: {
                        formatterSpec = LoggingSubsystemParser.parsePatternFormatterElement(reader);
                        break block0;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
        if (reader.nextTag() != 2) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return formatterSpec;
    }

    private static String parsePatternFormatterElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        String pattern = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATTERN);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATTERN: {
                    pattern = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return pattern;
    }

    private static ModelNode parseHandlersElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        ModelNode handlers = new ModelNode();
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case LOGGING_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case HANDLER: {
                            handlers.add(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"));
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return handlers;
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        ModelNode handler;
        String name;
        ModelNode handlers;
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        if (node.hasDefined("async-handler")) {
            handlers = node.get("async-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeAsynchHandler(writer, handler, name);
            }
        }
        if (node.hasDefined("console-handler")) {
            handlers = node.get("console-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeConsoleHandler(writer, handler, name);
            }
        }
        if (node.hasDefined("file-handler")) {
            handlers = node.get("file-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeFileHandler(writer, handler, name);
            }
        }
        if (node.hasDefined("periodic-rotating-file-handler")) {
            handlers = node.get("periodic-rotating-file-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writePeriodicRotatingFileHandler(writer, handler, name);
            }
        }
        if (node.hasDefined("size-rotating-file-handler")) {
            handlers = node.get("size-rotating-file-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeSizeRotatingFileHandler(writer, handler, name);
            }
        }
        if (node.hasDefined("logger")) {
            for (String name2 : node.get("logger").keys()) {
                this.writeLogger(writer, name2, node.get(new String[]{"logger", name2}));
            }
        }
        if (node.hasDefined("root-logger")) {
            this.writeRootLogger(writer, node.get("root-logger"));
        }
        writer.writeEndElement();
    }

    private void writeConsoleHandler(XMLExtendedStreamWriter writer, ModelNode node, String name) throws XMLStreamException {
        writer.writeStartElement(Element.CONSOLE_HANDLER.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), name);
        if (node.hasDefined("autoflush")) {
            this.writeAttribute(writer, Attribute.AUTOFLUSH, node.get("autoflush"));
        }
        this.writeLevel(writer, node);
        this.writeEncoding(writer, node);
        this.writeFilter(writer, node);
        this.writeFormatter(writer, node);
        this.writeProperties(writer, node);
        if (node.hasDefined("target")) {
            writer.writeStartElement(Element.TARGET.getLocalName());
            this.writeAttribute(writer, Attribute.NAME, node.get("target"));
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeFileHandler(XMLExtendedStreamWriter writer, ModelNode node, String name) throws XMLStreamException {
        writer.writeStartElement(Element.FILE_HANDLER.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), name);
        if (node.hasDefined("autoflush")) {
            this.writeAttribute(writer, Attribute.AUTOFLUSH, node.get("autoflush"));
        }
        this.writeLevel(writer, node);
        this.writeEncoding(writer, node);
        this.writeFilter(writer, node);
        this.writeFormatter(writer, node);
        this.writeProperties(writer, node);
        this.writeFile(writer, node);
        this.writeAppend(writer, node);
        writer.writeEndElement();
    }

    private void writePeriodicRotatingFileHandler(XMLExtendedStreamWriter writer, ModelNode node, String name) throws XMLStreamException {
        writer.writeStartElement(Element.PERIODIC_ROTATING_FILE_HANDLER.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), name);
        if (node.hasDefined("autoflush")) {
            this.writeAttribute(writer, Attribute.AUTOFLUSH, node.get("autoflush"));
        }
        this.writeLevel(writer, node);
        this.writeEncoding(writer, node);
        this.writeFilter(writer, node);
        this.writeFormatter(writer, node);
        this.writeProperties(writer, node);
        this.writeFile(writer, node);
        if (node.hasDefined("suffix")) {
            writer.writeStartElement(Element.SUFFIX.getLocalName());
            this.writeAttribute(writer, Attribute.VALUE, node.get("suffix"));
            writer.writeEndElement();
        }
        this.writeAppend(writer, node);
        writer.writeEndElement();
    }

    private void writeSizeRotatingFileHandler(XMLExtendedStreamWriter writer, ModelNode node, String name) throws XMLStreamException {
        writer.writeStartElement(Element.SIZE_ROTATING_FILE_HANDLER.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), name);
        if (node.hasDefined("autoflush")) {
            this.writeAttribute(writer, Attribute.AUTOFLUSH, node.get("autoflush"));
        }
        this.writeLevel(writer, node);
        this.writeEncoding(writer, node);
        this.writeFilter(writer, node);
        this.writeFormatter(writer, node);
        this.writeProperties(writer, node);
        this.writeFile(writer, node);
        if (node.hasDefined("rotate-size")) {
            writer.writeStartElement(Element.ROTATE_SIZE.getLocalName());
            this.writeAttribute(writer, Attribute.VALUE, node.get("rotate-size"));
            writer.writeEndElement();
        }
        if (node.hasDefined("max-backup-index")) {
            writer.writeStartElement(Element.MAX_BACKUP_INDEX.getLocalName());
            this.writeAttribute(writer, Attribute.VALUE, node.get("max-backup-index"));
            writer.writeEndElement();
        }
        this.writeAppend(writer, node);
        writer.writeEndElement();
    }

    private void writeAsynchHandler(XMLExtendedStreamWriter writer, ModelNode node, String name) throws XMLStreamException {
        writer.writeStartElement(Element.ASYNC_HANDLER.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), name);
        this.writeLevel(writer, node);
        this.writeFilter(writer, node);
        this.writeProperties(writer, node);
        if (node.hasDefined("queue-length")) {
            writer.writeStartElement(Element.QUEUE_LENGTH.getLocalName());
            this.writeAttribute(writer, Attribute.VALUE, node.get("queue-length"));
            writer.writeEndElement();
        }
        if (node.hasDefined("overflow-action")) {
            writer.writeStartElement(Element.OVERFLOW_ACTION.getLocalName());
            this.writeAttribute(writer, Attribute.VALUE, node.get("overflow-action"));
            writer.writeEndElement();
        }
        if (node.hasDefined("subhandlers")) {
            ModelNode handlers = node.get("subhandlers");
            this.writeHandlersContent(writer, Element.SUBHANDLERS, handlers);
        }
        writer.writeEndElement();
    }

    private void writeLogger(XMLExtendedStreamWriter writer, String name, ModelNode node) throws XMLStreamException {
        writer.writeStartElement(Element.LOGGER.getLocalName());
        writer.writeAttribute(Attribute.CATEGORY.getLocalName(), name);
        if (node.hasDefined("use-parent-handlers")) {
            this.writeAttribute(writer, Attribute.USE_PARENT_HANDLERS, node.get("use-parent-handlers"));
        }
        this.writeLevel(writer, node);
        this.writeFilter(writer, node);
        this.writeHandlers(writer, node);
        writer.writeEndElement();
    }

    private void writeRootLogger(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        writer.writeStartElement(Element.ROOT_LOGGER.getLocalName());
        this.writeLevel(writer, node);
        this.writeFilter(writer, node);
        this.writeHandlers(writer, node);
        writer.writeEndElement();
    }

    private void writeLevel(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (node.hasDefined("level")) {
            writer.writeStartElement(Element.LEVEL.getLocalName());
            this.writeAttribute(writer, Attribute.NAME, node.get("level"));
            writer.writeEndElement();
        }
    }

    private void writeFilter(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
    }

    private void writeProperties(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
    }

    private void writeFormatter(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (node.hasDefined("formatter")) {
            writer.writeStartElement(Element.FORMATTER.getLocalName());
            writer.writeStartElement(Element.PATTERN_FORMATTER.getLocalName());
            this.writeAttribute(writer, Attribute.PATTERN, node.get("formatter"));
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    private void writeFile(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (node.hasDefined("file")) {
            writer.writeStartElement(Element.FILE.getLocalName());
            ModelNode file = node.get("file");
            if (file.hasDefined("relative-to")) {
                this.writeAttribute(writer, Attribute.RELATIVE_TO, file.get("relative-to"));
            }
            if (file.hasDefined("path")) {
                this.writeAttribute(writer, Attribute.PATH, file.get("path"));
            }
            writer.writeEndElement();
        }
    }

    private void writeEncoding(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (node.hasDefined("encoding")) {
            writer.writeStartElement(Element.ENCODING.getLocalName());
            this.writeAttribute(writer, Attribute.VALUE, node.get("encoding"));
            writer.writeEndElement();
        }
    }

    private void writeHandlers(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (node.hasDefined("handlers")) {
            ModelNode handlers = node.get("handlers");
            this.writeHandlersContent(writer, Element.HANDLERS, handlers);
        }
    }

    private void writeHandlersContent(XMLExtendedStreamWriter writer, Element element, ModelNode handlers) throws XMLStreamException {
        if (handlers.getType() == ModelType.LIST) {
            writer.writeStartElement(Element.HANDLERS.getLocalName());
            for (ModelNode handler : handlers.asList()) {
                if (!handler.isDefined()) continue;
                writer.writeStartElement(Element.HANDLER.getLocalName());
                this.writeAttribute(writer, Attribute.NAME, handler);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeAppend(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (node.hasDefined("append")) {
            writer.writeStartElement(Element.APPEND.getLocalName());
            this.writeAttribute(writer, Attribute.VALUE, node.get("append"));
            writer.writeEndElement();
        }
    }

    private void writeAttribute(XMLExtendedStreamWriter writer, Attribute attr, ModelNode value) throws XMLStreamException {
        writer.writeAttribute(attr.getLocalName(), value.asString());
    }
}

