/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Handler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.logging.AbstractFormatterSpec;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.ModelParser;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

abstract class AbstractLogHandlerWriteAttributeHandler<T extends Handler>
extends AbstractWriteAttributeHandler<T> {
    private final Map<String, AttributeDefinition> attributes = new HashMap<String, AttributeDefinition>();

    AbstractLogHandlerWriteAttributeHandler(AttributeDefinition ... attributes) {
        this(Arrays.asList(attributes));
    }

    AbstractLogHandlerWriteAttributeHandler(Collection<AttributeDefinition> attributes) {
        this.attributes.put(CommonAttributes.LEVEL.getName(), (AttributeDefinition)CommonAttributes.LEVEL);
        this.attributes.put(CommonAttributes.FILTER.getName(), (AttributeDefinition)CommonAttributes.FILTER);
        this.attributes.put(CommonAttributes.FORMATTER.getName(), (AttributeDefinition)CommonAttributes.FORMATTER);
        this.attributes.put(CommonAttributes.ENCODING.getName(), (AttributeDefinition)CommonAttributes.ENCODING);
        this.attributes.put(CommonAttributes.FILTER.getName(), (AttributeDefinition)CommonAttributes.FILTER);
        for (AttributeDefinition attr : attributes) {
            this.attributes.put(attr.getName(), attr);
        }
    }

    protected final boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<T> handbackHolder) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
        ServiceController controller = serviceRegistry.getService(LogServices.handlerName(name));
        if (controller == null) {
            return false;
        }
        Handler handler = (Handler)controller.getValue();
        if (CommonAttributes.LEVEL.getName().equals(attributeName)) {
            handler.setLevel(ModelParser.parseLevel(resolvedValue));
        } else if (CommonAttributes.FILTER.getName().equals(attributeName)) {
            handler.setFilter(ModelParser.parseFilter(context, resolvedValue));
        } else if (CommonAttributes.FORMATTER.getName().equals(attributeName)) {
            AbstractFormatterSpec.fromModelNode(context, resolvedValue).apply(handler);
        } else if (CommonAttributes.ENCODING.getName().equals(attributeName)) {
            try {
                handler.setEncoding(resolvedValue.asString());
            }
            catch (UnsupportedEncodingException e) {
                throw new OperationFailedException((Throwable)e, new ModelNode().set(LoggingMessages.MESSAGES.failedToSetHandlerEncoding()));
            }
        }
        return this.doApplyUpdateToRuntime(context, operation, attributeName, resolvedValue, currentValue, name, handler);
    }

    protected final void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, T handler) throws OperationFailedException {
        if (handler != null) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String name = address.getLastElement().getValue();
            if (CommonAttributes.LEVEL.getName().equals(attributeName)) {
                ((Handler)handler).setLevel(ModelParser.parseLevel(valueToRestore));
            } else if (CommonAttributes.FILTER.getName().equals(attributeName)) {
                ((Handler)handler).setFilter(ModelParser.parseFilter(context, valueToRestore));
            } else if (CommonAttributes.FORMATTER.getName().equals(attributeName)) {
                AbstractFormatterSpec.fromModelNode(context, valueToRestore).apply((Handler)handler);
            } else if (CommonAttributes.ENCODING.getName().equals(attributeName)) {
                try {
                    ((Handler)handler).setEncoding(valueToRestore.asString());
                }
                catch (UnsupportedEncodingException e) {
                    throw new OperationFailedException((Throwable)e, new ModelNode().set(LoggingMessages.MESSAGES.failedToSetHandlerEncoding()));
                }
            }
            this.doRevertUpdateToRuntime(context, operation, attributeName, valueToRestore, valueToRevert, name, handler);
        }
    }

    protected abstract boolean doApplyUpdateToRuntime(OperationContext var1, ModelNode var2, String var3, ModelNode var4, ModelNode var5, String var6, T var7) throws OperationFailedException;

    protected abstract void doRevertUpdateToRuntime(OperationContext var1, ModelNode var2, String var3, ModelNode var4, ModelNode var5, String var6, T var7) throws OperationFailedException;

    protected final void validateResolvedValue(String name, ModelNode value) throws OperationFailedException {
        if (this.attributes.containsKey(name)) {
            this.attributes.get(name).getValidator().validateResolvedParameter(name, value);
        } else {
            super.validateResolvedValue(name, value);
        }
    }

    protected final void validateUnresolvedValue(String name, ModelNode value) throws OperationFailedException {
        if (this.attributes.containsKey(name)) {
            this.attributes.get(name).getValidator().validateParameter(name, value);
        } else {
            super.validateUnresolvedValue(name, value);
        }
    }

    protected AttributeDefinition getAttributeDefinition(String attributeName) {
        return this.attributes == null ? null : this.attributes.get(attributeName);
    }

    public final Collection<AttributeDefinition> getAttributes() {
        return Collections.unmodifiableCollection(this.attributes.values());
    }
}

