/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.Locale;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.AsyncHandlerAssignSubhandler;
import org.jboss.as.logging.AsyncHandlerUnassignSubhandler;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.HandlerUpdateProperties;
import org.jboss.as.logging.ModelParser;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.handlers.AsyncHandler;

public class AsyncHandlerUpdateProperties
extends HandlerUpdateProperties<AsyncHandler> {
    static final AsyncHandlerUpdateProperties INSTANCE = new AsyncHandlerUpdateProperties();
    static final String OPERATION_NAME = "update-properties";

    private AsyncHandlerUpdateProperties() {
        super(new AttributeDefinition[]{CommonAttributes.OVERFLOW_ACTION, CommonAttributes.SUBHANDLERS, CommonAttributes.QUEUE_LENGTH});
    }

    @Override
    protected boolean applyUpdateToRuntime(OperationContext context, String handlerName, ModelNode model, ModelNode originalModel, AsyncHandler handler) throws OperationFailedException {
        ModelNode subhandlers;
        ModelNode queueLength;
        boolean requireRestart = false;
        ModelNode overflowAction = CommonAttributes.OVERFLOW_ACTION.resolveModelAttribute(context, model);
        if (overflowAction.isDefined()) {
            handler.setOverflowAction(ModelParser.parseOverflowAction(overflowAction));
        }
        if ((queueLength = CommonAttributes.QUEUE_LENGTH.resolveModelAttribute(context, model)).isDefined()) {
            requireRestart = true;
        }
        if ((subhandlers = CommonAttributes.SUBHANDLERS.resolveModelAttribute(context, model)).isDefined()) {
            AsyncHandlerUnassignSubhandler.removeHandlers((AttributeDefinition)CommonAttributes.SUBHANDLERS, originalModel, context, handlerName);
            AsyncHandlerAssignSubhandler.addHandlers((AttributeDefinition)CommonAttributes.SUBHANDLERS, model, context, handlerName);
        }
        return requireRestart;
    }

    @Override
    protected void revertUpdateToRuntime(OperationContext context, String handlerName, ModelNode model, ModelNode originalModel, AsyncHandler handler) throws OperationFailedException {
        ModelNode overflowAction = CommonAttributes.OVERFLOW_ACTION.resolveModelAttribute(context, originalModel);
        if (overflowAction.isDefined()) {
            handler.setOverflowAction(AsyncHandler.OverflowAction.valueOf((String)overflowAction.asString().toUpperCase(Locale.US)));
        }
    }
}

