/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.AbstractLogHandlerWriteAttributeHandler;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.Target;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.handlers.ConsoleHandler;

public class ConsoleHandlerWriteAttributeHandler
extends AbstractLogHandlerWriteAttributeHandler<ConsoleHandler> {
    static final ConsoleHandlerWriteAttributeHandler INSTANCE = new ConsoleHandlerWriteAttributeHandler();

    private ConsoleHandlerWriteAttributeHandler() {
        super(new AttributeDefinition[]{CommonAttributes.AUTOFLUSH, CommonAttributes.TARGET});
    }

    @Override
    protected boolean doApplyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, String handlerName, ConsoleHandler handler) throws OperationFailedException {
        if (CommonAttributes.TARGET.getName().equals(attributeName)) {
            switch (Target.fromString(resolvedValue.asString())) {
                case SYSTEM_ERR: {
                    handler.setTarget(ConsoleHandler.Target.SYSTEM_ERR);
                    break;
                }
                case SYSTEM_OUT: {
                    handler.setTarget(ConsoleHandler.Target.SYSTEM_OUT);
                }
            }
        } else if (CommonAttributes.AUTOFLUSH.getName().equals(attributeName)) {
            handler.setAutoFlush(resolvedValue.asBoolean());
        }
        return false;
    }

    @Override
    protected void doRevertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, String handlerName, ConsoleHandler handler) throws OperationFailedException {
        if (CommonAttributes.TARGET.getName().equals(attributeName)) {
            switch (Target.fromString(valueToRestore.asString())) {
                case SYSTEM_ERR: {
                    handler.setTarget(ConsoleHandler.Target.SYSTEM_ERR);
                    break;
                }
                case SYSTEM_OUT: {
                    handler.setTarget(ConsoleHandler.Target.SYSTEM_OUT);
                }
            }
        } else if (CommonAttributes.AUTOFLUSH.getName().equals(attributeName)) {
            handler.setAutoFlush(valueToRestore.asBoolean());
        }
    }
}

