/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.HandlerUpdateProperties;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.handlers.FileHandler;

public class FileHandlerUpdateProperties
extends HandlerUpdateProperties<FileHandler> {
    static final FileHandlerUpdateProperties INSTANCE = new FileHandlerUpdateProperties();

    private FileHandlerUpdateProperties() {
        super(new AttributeDefinition[]{CommonAttributes.APPEND, CommonAttributes.AUTOFLUSH});
    }

    @Override
    protected boolean applyUpdateToRuntime(OperationContext context, String handlerName, ModelNode model, ModelNode originalModel, FileHandler handler) throws OperationFailedException {
        ModelNode append;
        ModelNode autoflush = CommonAttributes.AUTOFLUSH.resolveModelAttribute(context, model);
        if (autoflush.isDefined()) {
            handler.setAutoFlush(autoflush.asBoolean());
        }
        if ((append = CommonAttributes.APPEND.resolveModelAttribute(context, model)).isDefined()) {
            handler.setAppend(append.asBoolean());
        }
        return false;
    }

    @Override
    protected void revertUpdateToRuntime(OperationContext context, String handlerName, ModelNode model, ModelNode originalModel, FileHandler handler) throws OperationFailedException {
        ModelNode append;
        ModelNode autoflush = CommonAttributes.AUTOFLUSH.resolveModelAttribute(context, originalModel);
        if (autoflush.isDefined()) {
            handler.setAutoFlush(autoflush.asBoolean());
        }
        if ((append = CommonAttributes.APPEND.resolveModelAttribute(context, originalModel)).isDefined()) {
            handler.setAppend(append.asBoolean());
        }
    }
}

