/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.List;
import org.jboss.as.controller.AbstractModelUpdateHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.ModelParser;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.Logger;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

public class LoggerLevelChange
extends AbstractModelUpdateHandler {
    static final String OPERATION_NAME = "change-log-level";
    static final LoggerLevelChange INSTANCE = new LoggerLevelChange();

    protected void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        CommonAttributes.LEVEL.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        ModelNode level = CommonAttributes.LEVEL.resolveModelAttribute(context, model);
        ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
        ServiceController controller = serviceRegistry.getService(LogServices.loggerName(name));
        if (controller != null && level.isDefined()) {
            ((Logger)controller.getValue()).setLevel(ModelParser.parseLevel(level));
        }
    }
}

