/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.HandlerUpdateProperties;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.handlers.PeriodicRotatingFileHandler;

public class PeriodicHandlerUpdateProperties
extends HandlerUpdateProperties<PeriodicRotatingFileHandler> {
    static final PeriodicHandlerUpdateProperties INSTANCE = new PeriodicHandlerUpdateProperties();

    private PeriodicHandlerUpdateProperties() {
        super(new AttributeDefinition[]{CommonAttributes.APPEND, CommonAttributes.AUTOFLUSH, CommonAttributes.SUFFIX});
    }

    @Override
    protected boolean applyUpdateToRuntime(OperationContext context, String handlerName, ModelNode model, ModelNode originalModel, PeriodicRotatingFileHandler handler) throws OperationFailedException {
        ModelNode suffix;
        ModelNode append;
        ModelNode autoflush = CommonAttributes.AUTOFLUSH.resolveModelAttribute(context, model);
        if (autoflush.isDefined()) {
            handler.setAutoFlush(autoflush.asBoolean());
        }
        if ((append = CommonAttributes.APPEND.resolveModelAttribute(context, model)).isDefined()) {
            handler.setAppend(append.asBoolean());
        }
        if ((suffix = CommonAttributes.SUFFIX.resolveModelAttribute(context, model)).isDefined()) {
            handler.setSuffix(suffix.asString());
        }
        return false;
    }

    @Override
    protected void revertUpdateToRuntime(OperationContext context, String handlerName, ModelNode model, ModelNode originalModel, PeriodicRotatingFileHandler handler) throws OperationFailedException {
        ModelNode suffix;
        ModelNode append;
        ModelNode autoflush = CommonAttributes.AUTOFLUSH.resolveModelAttribute(context, originalModel);
        if (autoflush.isDefined()) {
            handler.setAutoFlush(autoflush.asBoolean());
        }
        if ((append = CommonAttributes.APPEND.resolveModelAttribute(context, originalModel)).isDefined()) {
            handler.setAppend(append.asBoolean());
        }
        if ((suffix = CommonAttributes.SUFFIX.resolveModelAttribute(context, originalModel)).isDefined()) {
            handler.setSuffix(suffix.asString());
        }
    }
}

