/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.ModelParser;
import org.jboss.as.logging.RootLoggerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

class RootLoggerAdd
extends AbstractAddStepHandler {
    static final RootLoggerAdd INSTANCE = new RootLoggerAdd();
    static final String OPERATION_NAME = "set-root-logger";

    RootLoggerAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        CommonAttributes.LEVEL.validateAndSet(operation, model);
        CommonAttributes.HANDLERS.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{LoggingExtension.rootLoggerPath});
        String name = address.getLastElement().getValue();
        ModelNode level = CommonAttributes.LEVEL.resolveModelAttribute(context, model);
        ModelNode handlers = CommonAttributes.HANDLERS.resolveModelAttribute(context, model);
        ServiceTarget target = context.getServiceTarget();
        try {
            RootLoggerService service = new RootLoggerService();
            if (level.isDefined()) {
                service.setLevel(ModelParser.parseLevel(level));
            }
            newControllers.add(target.addService(LogServices.loggerName(name), (Service)service).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
        }
        catch (Throwable t) {
            throw new OperationFailedException(new ModelNode().set(t.getLocalizedMessage()));
        }
        try {
            if (handlers.isDefined()) {
                newControllers.addAll(LogServices.installLoggerHandlers(target, name, handlers, verificationHandler));
            }
        }
        catch (Throwable t) {
            throw new OperationFailedException(new ModelNode().set(t.getLocalizedMessage()));
        }
    }
}

