/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers.async;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Handler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.handlers.HandlerAddProperties;
import org.jboss.as.logging.handlers.async.AsyncHandlerService;
import org.jboss.as.logging.util.LogServices;
import org.jboss.as.logging.util.ModelParser;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.value.InjectedValue;

public class AsyncHandlerAdd
extends HandlerAddProperties<AsyncHandlerService> {
    public static final AsyncHandlerAdd INSTANCE = new AsyncHandlerAdd();

    private AsyncHandlerAdd() {
        super(Arrays.asList(new AttributeDefinition[]{CommonAttributes.SUBHANDLERS, CommonAttributes.QUEUE_LENGTH, CommonAttributes.OVERFLOW_ACTION}));
    }

    @Override
    protected void updateRuntime(OperationContext context, ServiceBuilder<Handler> serviceBuilder, String name, AsyncHandlerService service, ModelNode model, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ArrayList<InjectedValue<Handler>> list = new ArrayList<InjectedValue<Handler>>();
        ModelNode subhandlers = CommonAttributes.SUBHANDLERS.resolveModelAttribute(context, model);
        if (subhandlers.isDefined()) {
            for (ModelNode handlerName : subhandlers.asList()) {
                if (name.equals(handlerName.asString())) {
                    throw new OperationFailedException(LoggingMessages.MESSAGES.cannotAddHandlerToSelf(name));
                }
                InjectedValue injectedValue = new InjectedValue();
                serviceBuilder.addDependency(LogServices.handlerName(handlerName.asString()), Handler.class, (Injector)injectedValue);
                list.add((InjectedValue<Handler>)injectedValue);
            }
        }
        service.addHandlers(list);
        service.setQueueLength(CommonAttributes.QUEUE_LENGTH.resolveModelAttribute(context, model).asInt());
        ModelNode overflowAction = CommonAttributes.OVERFLOW_ACTION.resolveModelAttribute(context, model);
        if (overflowAction.isDefined()) {
            service.setOverflowAction(ModelParser.parseOverflowAction(overflowAction));
        }
    }

    @Override
    protected AsyncHandlerService createHandlerService(OperationContext context, ModelNode model) throws OperationFailedException {
        return new AsyncHandlerService();
    }
}

