/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers.async;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.handlers.AbstractLogHandlerWriteAttributeHandler;
import org.jboss.as.logging.handlers.async.AsyncHandlerAssignSubhandler;
import org.jboss.as.logging.handlers.async.AsyncHandlerService;
import org.jboss.as.logging.handlers.async.AsyncHandlerUnassignSubhandler;
import org.jboss.as.logging.util.ModelParser;
import org.jboss.dmr.ModelNode;

public class AsyncHandlerWriteAttributeHandler
extends AbstractLogHandlerWriteAttributeHandler<AsyncHandlerService> {
    public static final AsyncHandlerWriteAttributeHandler INSTANCE = new AsyncHandlerWriteAttributeHandler();

    private AsyncHandlerWriteAttributeHandler() {
        super(new AttributeDefinition[]{CommonAttributes.OVERFLOW_ACTION, CommonAttributes.SUBHANDLERS, CommonAttributes.QUEUE_LENGTH});
    }

    @Override
    protected boolean doApplyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, String handlerName, AsyncHandlerService handlerService) throws OperationFailedException {
        if (CommonAttributes.OVERFLOW_ACTION.getName().equals(attributeName)) {
            handlerService.setOverflowAction(ModelParser.parseOverflowAction(resolvedValue));
        } else if (CommonAttributes.SUBHANDLERS.getName().equals(attributeName)) {
            AsyncHandlerUnassignSubhandler.removeHandlers((AttributeDefinition)CommonAttributes.SUBHANDLERS, currentValue, context, handlerName);
            AsyncHandlerAssignSubhandler.addHandlers((AttributeDefinition)CommonAttributes.SUBHANDLERS, resolvedValue, context, handlerName);
        } else if (CommonAttributes.QUEUE_LENGTH.getName().equals(attributeName)) {
            return true;
        }
        return false;
    }

    @Override
    protected void doRevertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, String handlerName, AsyncHandlerService handlerService) throws OperationFailedException {
        if (CommonAttributes.OVERFLOW_ACTION.getName().equals(attributeName)) {
            handlerService.setOverflowAction(ModelParser.parseOverflowAction(valueToRestore));
        } else if (CommonAttributes.SUBHANDLERS.getName().equals(attributeName)) {
            AsyncHandlerUnassignSubhandler.removeHandlers((AttributeDefinition)CommonAttributes.SUBHANDLERS, valueToRevert, context, handlerName);
            AsyncHandlerAssignSubhandler.addHandlers((AttributeDefinition)CommonAttributes.SUBHANDLERS, valueToRestore, context, handlerName);
        }
    }
}

