/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers.custom;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.BasicConfigurator;
import org.jboss.as.logging.LoggingLogger;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.handlers.custom.Log4jAppenderHandler;
import org.jboss.dmr.Property;

class PropertiesConfigurator {
    private final Handler handler;
    private final Map<String, Method> methods;

    private PropertiesConfigurator(Handler handler) {
        this.handler = handler;
        this.methods = new HashMap<String, Method>();
        BasicConfigurator.configure();
    }

    public static void setProperties(Handler handler, List<Property> properties) {
        Appender appender;
        PropertiesConfigurator result = new PropertiesConfigurator(handler);
        result.loadSetterMethods();
        for (Property property : properties) {
            result.setProperty(property);
        }
        if (result.isLog4jAppender() && (appender = result.getAppender()) instanceof AppenderSkeleton) {
            ((AppenderSkeleton)AppenderSkeleton.class.cast(appender)).activateOptions();
        }
    }

    private void setProperty(Property property) {
        String setterMethod = PropertiesConfigurator.setterName(property.getName());
        try {
            if (this.methods.containsKey(setterMethod)) {
                Method method = this.methods.get(setterMethod);
                Object arg = this.getArgument(method, property.getName(), property.getValue().asString());
                if (this.isLog4jAppender()) {
                    Appender appender = this.getAppender();
                    if (appender == null) {
                        throw LoggingMessages.MESSAGES.handlerClosed(property.getName(), property.getValue().asString());
                    }
                    method.invoke((Object)appender, arg);
                } else {
                    method.invoke((Object)this.handler, arg);
                }
                LoggingLogger.ROOT_LOGGER.debugf("Set property '%s' with value of '%s' on handler '%s'.", property.getName(), property.getValue().asString(), this.handler.getClass().getName());
            } else {
                LoggingLogger.ROOT_LOGGER.unknownProperty(property.getName(), this.handler.getClass().getName());
            }
        }
        catch (Throwable t) {
            LoggingLogger.ROOT_LOGGER.errorSettingProperty(t, property.getName(), this.handler.getClass().getName());
        }
    }

    private Object getArgument(Method method, String propertyName, String propValue) throws IllegalArgumentException {
        Object argument;
        Class<?> objClass = method.getDeclaringClass();
        Class<?> paramType = method.getParameterTypes()[0];
        if (paramType == String.class) {
            argument = propValue;
        } else if (paramType == Boolean.TYPE || paramType == Boolean.class) {
            argument = Boolean.valueOf(propValue);
        } else if (paramType == Byte.TYPE || paramType == Byte.class) {
            argument = Byte.valueOf(propValue);
        } else if (paramType == Short.TYPE || paramType == Short.class) {
            argument = Short.valueOf(propValue);
        } else if (paramType == Integer.TYPE || paramType == Integer.class) {
            argument = Integer.valueOf(propValue);
        } else if (paramType == Long.TYPE || paramType == Long.class) {
            argument = Long.valueOf(propValue);
        } else if (paramType == Float.TYPE || paramType == Float.class) {
            argument = Float.valueOf(propValue);
        } else if (paramType == Double.TYPE || paramType == Double.class) {
            argument = Double.valueOf(propValue);
        } else if (paramType == Character.TYPE || paramType == Character.class) {
            argument = Character.valueOf(propValue.length() > 0 ? propValue.charAt(0) : (char)'\u0000');
        } else if (paramType == BigDecimal.class) {
            argument = new BigDecimal(propValue);
        } else if (paramType == File.class) {
            argument = new File(propValue);
        } else if (paramType == Level.class) {
            argument = Level.parse(propValue);
        } else if (paramType == TimeZone.class) {
            argument = TimeZone.getTimeZone(propValue);
        } else if (paramType == Charset.class) {
            argument = Charset.forName(propValue);
        } else if (paramType.isEnum()) {
            argument = Enum.valueOf(paramType.asSubclass(Enum.class), propValue);
        } else {
            throw LoggingMessages.MESSAGES.unknownParameterType(paramType, propertyName, objClass);
        }
        return argument;
    }

    private void loadSetterMethods() {
        Class<?> handlerClass;
        if (this.isLog4jAppender()) {
            Appender appender = this.getAppender();
            if (appender == null) {
                throw LoggingMessages.MESSAGES.handlerClosed();
            }
            handlerClass = appender.getClass();
        } else {
            handlerClass = this.handler.getClass();
        }
        for (Method method : handlerClass.getMethods()) {
            Class<?>[] parameterTypes;
            int modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || !method.getName().startsWith("set") || (parameterTypes = method.getParameterTypes()).length != 1 || method.getReturnType() != Void.TYPE) continue;
            this.methods.put(method.getName(), method);
        }
    }

    private boolean isLog4jAppender() {
        return this.handler instanceof Log4jAppenderHandler;
    }

    private Appender getAppender() {
        return ((Log4jAppenderHandler)((Object)Log4jAppenderHandler.class.cast(this.handler))).getAppender();
    }

    private static String setterName(String propertyName) {
        StringBuilder sb = new StringBuilder("set");
        sb.append(Character.toUpperCase(propertyName.charAt(0)));
        sb.append(propertyName.substring(1));
        return sb.toString();
    }
}

