/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers.file;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.handlers.HandlerUpdateProperties;
import org.jboss.as.logging.handlers.file.FileHandlerService;
import org.jboss.as.logging.handlers.file.FileHandlers;
import org.jboss.dmr.ModelNode;

public class FileHandlerUpdateProperties
extends HandlerUpdateProperties<FileHandlerService> {
    public static final FileHandlerUpdateProperties INSTANCE = new FileHandlerUpdateProperties();

    private FileHandlerUpdateProperties() {
        super(new AttributeDefinition[]{CommonAttributes.APPEND, CommonAttributes.AUTOFLUSH, CommonAttributes.FILE});
    }

    @Override
    protected boolean applyUpdateToRuntime(OperationContext context, String handlerName, ModelNode model, ModelNode originalModel, FileHandlerService handlerService) throws OperationFailedException {
        ModelNode file;
        ModelNode append;
        boolean requiresRestart = false;
        ModelNode autoflush = CommonAttributes.AUTOFLUSH.resolveModelAttribute(context, model);
        if (autoflush.isDefined()) {
            handlerService.setAutoFlush(autoflush.asBoolean());
        }
        if ((append = CommonAttributes.APPEND.resolveModelAttribute(context, model)).isDefined()) {
            handlerService.setAppend(append.asBoolean());
        }
        if ((file = CommonAttributes.FILE.resolveModelAttribute(context, model)).isDefined()) {
            requiresRestart = FileHandlers.changeFile(context, originalModel.get(CommonAttributes.FILE.getName()), file, handlerName);
        }
        return requiresRestart;
    }

    @Override
    protected void revertUpdateToRuntime(OperationContext context, String handlerName, ModelNode model, ModelNode originalModel, FileHandlerService handlerService) throws OperationFailedException {
        ModelNode file;
        ModelNode append;
        ModelNode autoflush = CommonAttributes.AUTOFLUSH.resolveModelAttribute(context, originalModel);
        if (autoflush.isDefined()) {
            handlerService.setAutoFlush(autoflush.asBoolean());
        }
        if ((append = CommonAttributes.APPEND.resolveModelAttribute(context, originalModel)).isDefined()) {
            handlerService.setAppend(append.asBoolean());
        }
        if ((file = CommonAttributes.FILE.resolveModelAttribute(context, originalModel)).isDefined()) {
            FileHandlers.revertFileChange(context, file, handlerName);
        }
    }
}

