/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.HashMap;
import java.util.Map;

enum Element {
    UNKNOWN(null),
    AUTO_GROUP("auto-group"),
    BLOCK_ON_ACK("block-on-acknowledge"),
    BLOCK_ON_DURABLE_SEND("block-on-durable-send"),
    BLOCK_ON_NON_DURABLE_SEND("block-on-non-durable-send"),
    CACHE_LARGE_MESSAGE_CLIENT("cache-large-message-client"),
    CALL_TIMEOUT("call-timeout"),
    CLIENT_FAILURE_CHECK_PERIOD("client-failure-check-period"),
    CLIENT_ID("client-id"),
    CONNECTION_FACTORY("connection-factory"),
    CONNECTOR_REF("connector-ref"),
    CONNECTORS("connectors"),
    CONNECTION_TTL("connection-ttl"),
    CONFIRMATION_WINDOW_SIZE("confirmation-window-size"),
    CONSUMER_MAX_RATE("consumer-max-rate"),
    CONSUMER_WINDOW_SIZE("consumer-window-size"),
    DISCOVERY_INITIAL_WAIT_TIMEOUT("discovery-initial-wait-timeout"),
    DISCOVERY_GROUP_REF("discovery-group-ref"),
    DUPS_OK_BATCH_SIZE("dups-ok-batch-size"),
    DURABLE("durable"),
    ENTRIES("entries"),
    ENTRY("entry"),
    FAILOVER_ON_INITIAL_CONNECTION("failover-on-initial-connection"),
    FAILOVER_ON_SERVER_SHUTDOWN("failover-on-server-shutdown"),
    GROUP_ID("group-id"),
    LOAD_BALANCING_CLASS_NAME("connection-load-balancing-policy-class-name"),
    MAX_RETRY_INTERVAL("max-retry-interval"),
    MIN_LARGE_MESSAGE_SIZE("min-large-message-size"),
    PRE_ACK("pre-acknowledge"),
    PRODUCER_WINDOW_SIZE("producer-window-size"),
    PRODUCER_MAX_RATE("producer-max-rate"),
    QUEUE("queue"),
    RECONNECT_ATTEMPTS("reconnect-attempts"),
    RETRY_INTERVAL("retry-interval"),
    RETRY_INTERVAL_MULTIPLIER("retry-interval-multiplier"),
    SELECTOR("selector"),
    SCHEDULED_THREAD_POOL_MAX_SIZE("scheduled-thread-pool-max-size"),
    THREAD_POOL_MAX_SIZE("thread-pool-max-size"),
    TOPIC("topic"),
    TRANSACTION_BATH_SIZE("transaction-batch-size"),
    USE_GLOBAL_POOLS("use-global-pools");

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

