/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.messaging.jms.Attribute;
import org.jboss.as.messaging.jms.Element;
import org.jboss.as.messaging.jms.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JMSSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    private static final JMSSubsystemParser INSTANCE = new JMSSubsystemParser();

    public static JMSSubsystemParser getInstance() {
        return INSTANCE;
    }

    private JMSSubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> updates) throws XMLStreamException {
        ModelNode address = new ModelNode();
        address.add("subsystem", "jms");
        address.protect();
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        updates.add(operation);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CONNECTION_FACTORY: {
                    JMSSubsystemParser.processConnectionFactory(reader, address, updates);
                    continue block5;
                }
                case QUEUE: {
                    JMSSubsystemParser.processJMSQueue(reader, address, updates);
                    continue block5;
                }
                case TOPIC: {
                    JMSSubsystemParser.processJMSTopic(reader, address, updates);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void processJMSTopic(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        String name = reader.getAttributeValue(0);
        if (name == null) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        ModelNode topic = new ModelNode();
        topic.get("operation").set("add");
        topic.get("address").set(address).add("topic", name);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ENTRY: {
                    String entry = reader.getAttributeValue(0);
                    topic.get("entries").add(entry.trim());
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        updates.add(topic);
    }

    static void processJMSQueue(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        String name = reader.getAttributeValue(0);
        if (name == null) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        ModelNode queue = new ModelNode();
        queue.get("operation").set("add");
        queue.get("address").set(address).add("queue", name);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ENTRY: {
                    String entry = reader.getAttributeValue(0);
                    queue.get("entries").add(entry.trim());
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block5;
                }
                case SELECTOR: {
                    if (queue.has("selector")) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.SELECTOR.getLocalName());
                    }
                    queue.get("selector").set(reader.getElementText().trim());
                    continue block5;
                }
                case DURABLE: {
                    if (queue.has("durable")) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.DURABLE.getLocalName());
                    }
                    queue.get("durable").set(Boolean.valueOf(reader.getElementText()).booleanValue());
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        updates.add(queue);
    }

    static void processConnectionFactory(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        String name = reader.getAttributeValue(0);
        if (name == null) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        ModelNode connectionFactory = new ModelNode();
        connectionFactory.get("operation").set("add");
        connectionFactory.get("address").set(address).add("connection-factory", name);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DISCOVERY_GROUP_REF: {
                    String groupRef = reader.getAttributeValue(0);
                    if (groupRef != null) {
                        connectionFactory.get("discovery-group-ref").add(groupRef);
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block6;
                }
                case CONNECTORS: {
                    connectionFactory.get("connector").set(JMSSubsystemParser.processConnectors(reader));
                    continue block6;
                }
                case ENTRIES: {
                    while (reader.hasNext() && reader.nextTag() != 2) {
                        Element local = Element.forName(reader.getLocalName());
                        if (local != Element.ENTRY) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        String entry = reader.getAttributeValue(0);
                        connectionFactory.get("entries").add(entry.trim());
                        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    }
                    continue block6;
                }
                case DISCOVERY_INITIAL_WAIT_TIMEOUT: 
                case CLIENT_FAILURE_CHECK_PERIOD: 
                case CONNECTION_TTL: 
                case CALL_TIMEOUT: 
                case CONSUMER_WINDOW_SIZE: 
                case CONSUMER_MAX_RATE: 
                case CONFIRMATION_WINDOW_SIZE: 
                case PRODUCER_WINDOW_SIZE: 
                case PRODUCER_MAX_RATE: 
                case CACHE_LARGE_MESSAGE_CLIENT: 
                case MIN_LARGE_MESSAGE_SIZE: 
                case CLIENT_ID: 
                case DUPS_OK_BATCH_SIZE: 
                case TRANSACTION_BATH_SIZE: 
                case BLOCK_ON_ACK: 
                case BLOCK_ON_NON_DURABLE_SEND: 
                case BLOCK_ON_DURABLE_SEND: 
                case AUTO_GROUP: 
                case PRE_ACK: 
                case RETRY_INTERVAL: 
                case RETRY_INTERVAL_MULTIPLIER: 
                case MAX_RETRY_INTERVAL: 
                case RECONNECT_ATTEMPTS: 
                case FAILOVER_ON_INITIAL_CONNECTION: 
                case FAILOVER_ON_SERVER_SHUTDOWN: 
                case LOAD_BALANCING_CLASS_NAME: 
                case USE_GLOBAL_POOLS: 
                case SCHEDULED_THREAD_POOL_MAX_SIZE: 
                case THREAD_POOL_MAX_SIZE: 
                case GROUP_ID: {
                    JMSSubsystemParser.parseElementText(reader, element, connectionFactory);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        updates.add(connectionFactory);
    }

    static ModelNode processConnectors(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode connectors = new ModelNode();
        while (reader.hasNext() && reader.nextTag() != 2) {
            String name = null;
            String backup = null;
            int count = reader.getAttributeCount();
            block5: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case CONNECTOR_NAME: {
                        name = value.trim();
                        continue block5;
                    }
                    case CONNECTOR_BACKUP_NAME: {
                        backup = value.trim();
                        continue block5;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.CONNECTOR_NAME));
            }
            Element element = Element.forName(reader.getLocalName());
            if (element != Element.CONNECTOR_REF) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            ModelNode connector = connectors.get(name).setEmptyObject();
            if (backup == null) continue;
            connector.get("backup-connector-name").set(backup);
        }
        return connectors;
    }

    static void parseElementText(XMLExtendedStreamReader reader, Element element, ModelNode node) throws XMLStreamException {
        String value = reader.getElementText();
        if (value != null && value.length() > 0) {
            node.get(element.getLocalName()).set(value.trim());
        }
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        if (node.has("connection-factory")) {
            this.writeConnectionFactories(writer, node.get("connection-factory"));
        }
        if (node.has("queue")) {
            this.writeQueues(writer, node.get("queue"));
        }
        if (node.has("topic")) {
            this.writeTopics(writer, node.get("topic"));
        }
        writer.writeEndElement();
    }

    private void writeConnectionFactories(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        for (Property prop : node.asPropertyList()) {
            ModelNode entries;
            String name = prop.getName();
            ModelNode factory = prop.getValue();
            if (!factory.isDefined()) continue;
            writer.writeStartElement(Element.CONNECTION_FACTORY.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), name);
            if (this.has(factory, "discovery-group-ref")) {
                writer.writeStartElement(Element.DISCOVERY_GROUP_REF.getLocalName());
                this.writeAttribute(writer, Attribute.DISCOVERY_GROUP_NAME, factory.get("discovery-group-ref"));
                writer.writeEndElement();
            }
            if (this.has(factory, "connector")) {
                writer.writeStartElement(Element.CONNECTORS.getLocalName());
                for (Property connProp : factory.get("connector").asPropertyList()) {
                    ModelNode conn = connProp.getValue();
                    if (!conn.isDefined()) continue;
                    writer.writeStartElement(Element.CONNECTOR_REF.getLocalName());
                    writer.writeAttribute(Attribute.CONNECTOR_NAME.getLocalName(), connProp.getName());
                    if (this.has(conn, "backup-connector-name")) {
                        this.writeAttribute(writer, Attribute.CONNECTOR_BACKUP_NAME, conn.get("backup-connector-name"));
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            if (this.has(factory, "entries") && (entries = factory.get("entries")).getType() == ModelType.LIST) {
                writer.writeStartElement(Element.ENTRIES.getLocalName());
                for (ModelNode entry : entries.asList()) {
                    if (!entry.isDefined()) continue;
                    writer.writeStartElement(Element.ENTRY.getLocalName());
                    this.writeAttribute(writer, Attribute.NAME, entry);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            if (this.has(factory, "discovery-initial-wait-timeout")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.DISCOVERY_INITIAL_WAIT_TIMEOUT, node);
            }
            if (this.has(factory, "client-failure-check-period")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.DISCOVERY_INITIAL_WAIT_TIMEOUT, node);
            }
            if (this.has(factory, "connection-ttl")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.CONNECTION_TTL, node);
            }
            if (this.has(factory, "call-timeout")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.CALL_TIMEOUT, node);
            }
            if (this.has(factory, "consumer-window-size")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.CONSUMER_WINDOW_SIZE, node);
            }
            if (this.has(factory, "consumer-max-rate")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.CONSUMER_MAX_RATE, node);
            }
            if (this.has(factory, "confirmation-window-size")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.CONFIRMATION_WINDOW_SIZE, node);
            }
            if (this.has(factory, "producer-window-size")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.PRODUCER_WINDOW_SIZE, node);
            }
            if (this.has(factory, "producer-max-rate")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.PRODUCER_MAX_RATE, node);
            }
            if (this.has(factory, "cache-large-message-client")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.CACHE_LARGE_MESSAGE_CLIENT, node);
            }
            if (this.has(factory, "min-large-message-size")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.MIN_LARGE_MESSAGE_SIZE, node);
            }
            if (this.has(factory, "client-id")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.CLIENT_ID, node);
            }
            if (this.has(factory, "dups-ok-batch-size")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.DUPS_OK_BATCH_SIZE, node);
            }
            if (this.has(factory, "transaction-batch-size")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.TRANSACTION_BATH_SIZE, node);
            }
            if (this.has(factory, "block-on-acknowledge")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.BLOCK_ON_ACK, node);
            }
            if (this.has(factory, "block-on-non-durable-send")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.BLOCK_ON_NON_DURABLE_SEND, node);
            }
            if (this.has(factory, "block-on-durable-send")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.BLOCK_ON_DURABLE_SEND, node);
            }
            if (this.has(factory, "auto-group")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.AUTO_GROUP, node);
            }
            if (this.has(factory, "pre-acknowledge")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.PRE_ACK, node);
            }
            if (this.has(factory, "retry-interval-multiplier")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.RETRY_INTERVAL_MULTIPLIER, node);
            }
            if (this.has(factory, "max-retry-interval")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.MAX_RETRY_INTERVAL, node);
            }
            if (this.has(factory, "reconnect-attempts")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.RECONNECT_ATTEMPTS, node);
            }
            if (this.has(factory, "failover-on-initial-connection")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.FAILOVER_ON_INITIAL_CONNECTION, node);
            }
            if (this.has(factory, "failover-on-server-shutdown")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.FAILOVER_ON_SERVER_SHUTDOWN, node);
            }
            if (this.has(factory, "connection-load-balancing-policy-class-name")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.LOAD_BALANCING_CLASS_NAME, node);
            }
            if (this.has(factory, "use-global-pools")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.USE_GLOBAL_POOLS, node);
            }
            if (this.has(factory, "scheduled-thread-pool-max-size")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.SCHEDULED_THREAD_POOL_MAX_SIZE, node);
            }
            if (this.has(factory, "thread-pool-max-size")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.THREAD_POOL_MAX_SIZE, node);
            }
            if (this.has(factory, "group-id")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.GROUP_ID, node);
            }
            writer.writeEndElement();
        }
    }

    private void writeQueues(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        for (Property prop : node.asPropertyList()) {
            ModelNode entries;
            String name = prop.getName();
            ModelNode queue = prop.getValue();
            if (!queue.isDefined()) continue;
            writer.writeStartElement(Element.QUEUE.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), name);
            if (queue.has("entries") && (entries = queue.get("entries")).getType() == ModelType.LIST) {
                for (ModelNode entry : entries.asList()) {
                    if (!entry.isDefined()) continue;
                    writer.writeStartElement(Element.ENTRY.getLocalName());
                    this.writeAttribute(writer, Attribute.NAME, entry);
                    writer.writeEndElement();
                }
            }
            if (this.has(queue, "durable")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.DURABLE, queue);
            }
            if (this.has(queue, "selector")) {
                JMSSubsystemParser.writeSimpleElement(writer, Element.SELECTOR, queue);
            }
            writer.writeEndElement();
        }
    }

    private void writeTopics(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        for (Property prop : node.asPropertyList()) {
            ModelNode entries;
            String name = prop.getName();
            ModelNode topic = prop.getValue();
            if (!topic.isDefined()) continue;
            writer.writeStartElement(Element.TOPIC.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), name);
            if (topic.has("entries") && (entries = topic.get("entries")).getType() == ModelType.LIST) {
                for (ModelNode entry : entries.asList()) {
                    if (!entry.isDefined()) continue;
                    writer.writeStartElement(Element.ENTRY.getLocalName());
                    this.writeAttribute(writer, Attribute.NAME, entry);
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
        }
    }

    static void writeSimpleElement(XMLExtendedStreamWriter writer, Element element, ModelNode node) throws XMLStreamException {
        String content;
        String localName = element.getLocalName();
        if (node.has(localName) && (content = node.get(localName).asString()) != null) {
            writer.writeStartElement(localName);
            writer.writeCharacters(content);
            writer.writeEndElement();
        }
    }

    private boolean has(ModelNode node, String name) {
        return node.has(name) && node.get(name).isDefined();
    }

    private void writeAttribute(XMLExtendedStreamWriter writer, Attribute attr, ModelNode value) throws XMLStreamException {
        writer.writeAttribute(attr.getLocalName(), value.asString());
    }
}

