/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.hornetq.core.config.ClusterConnectionConfiguration;
import org.hornetq.core.config.Configuration;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.ConnectorRefsAttribute;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class ClusterConnectionAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final ClusterConnectionAdd INSTANCE = new ClusterConnectionAdd();

    public static ModelNode getAddOperation(ModelNode address, ModelNode subModel) {
        ModelNode operation = Util.getOperation((String)"add", (ModelNode)address, (ModelNode)subModel);
        return operation;
    }

    private ClusterConnectionAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        model.setEmptyObject();
        boolean hasStatic = operation.hasDefined(ConnectorRefsAttribute.CLUSTER_CONNECTION_CONNECTORS.getName());
        boolean hasDiscGroup = operation.hasDefined(CommonAttributes.DISCOVERY_GROUP_NAME.getName());
        if (hasStatic && hasDiscGroup) {
            throw new OperationFailedException(new ModelNode().set(String.format("Operation cannot include both parameter %s and parameter %s", ConnectorRefsAttribute.CLUSTER_CONNECTION_CONNECTORS.getName(), CommonAttributes.DISCOVERY_GROUP_NAME.getName())));
        }
        for (AttributeDefinition attributeDefinition : CommonAttributes.CLUSTER_CONNECTION_ATTRIBUTES) {
            if (hasDiscGroup && attributeDefinition == ConnectorRefsAttribute.CLUSTER_CONNECTION_CONNECTORS || hasStatic && attributeDefinition == CommonAttributes.DISCOVERY_GROUP_NAME) continue;
            attributeDefinition.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceName hqServiceName;
        ServiceRegistry registry = context.getServiceRegistry(false);
        ServiceController hqService = registry.getService(hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (hqService != null) {
            context.reloadRequired();
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        return MessagingDescriptions.getClusterConnectionAdd(locale);
    }

    static void addClusterConnectionConfigs(OperationContext context, Configuration configuration, ModelNode model) throws OperationFailedException {
        if (model.hasDefined("cluster-connection")) {
            List configs = configuration.getClusterConfigurations();
            for (Property prop : model.get("cluster-connection").asPropertyList()) {
                configs.add(ClusterConnectionAdd.createClusterConnectionConfiguration(context, prop.getName(), prop.getValue()));
            }
        }
    }

    static ClusterConnectionConfiguration createClusterConnectionConfiguration(OperationContext context, String name, ModelNode model) throws OperationFailedException {
        String address = CommonAttributes.CLUSTER_CONNECTION_ADDRESS.resolveModelAttribute(context, model).asString();
        String connectorName = CommonAttributes.CONNECTOR_REF.resolveModelAttribute(context, model).asString();
        long retryInterval = CommonAttributes.CLUSTER_CONNECTION_RETRY_INTERVAL.resolveModelAttribute(context, model).asLong();
        boolean duplicateDetection = CommonAttributes.CLUSTER_CONNECTION_USE_DUPLICATE_DETECTION.resolveModelAttribute(context, model).asBoolean();
        boolean forwardWhenNoConsumers = CommonAttributes.FORWARD_WHEN_NO_CONSUMERS.resolveModelAttribute(context, model).asBoolean();
        int maxHops = CommonAttributes.MAX_HOPS.resolveModelAttribute(context, model).asInt();
        int confirmationWindowSize = CommonAttributes.CONFIRMATION_WINDOW_SIZE.resolveModelAttribute(context, model).asInt();
        ModelNode discoveryNode = CommonAttributes.DISCOVERY_GROUP_NAME.resolveModelAttribute(context, model);
        String discoveryGroupName = discoveryNode.isDefined() ? discoveryNode.asString() : null;
        List<String> staticConnectors = discoveryGroupName == null ? ClusterConnectionAdd.getStaticConnectors(model) : null;
        boolean allowDirectOnly = CommonAttributes.ALLOW_DIRECT_CONNECTIONS_ONLY.resolveModelAttribute(context, model).asBoolean();
        if (discoveryGroupName != null) {
            return new ClusterConnectionConfiguration(name, address, connectorName, retryInterval, duplicateDetection, forwardWhenNoConsumers, maxHops, confirmationWindowSize, discoveryGroupName);
        }
        return new ClusterConnectionConfiguration(name, address, connectorName, retryInterval, duplicateDetection, forwardWhenNoConsumers, maxHops, confirmationWindowSize, staticConnectors, allowDirectOnly);
    }

    private static List<String> getStaticConnectors(ModelNode model) {
        if (!model.hasDefined("static-connectors")) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (ModelNode connector : model.require("static-connectors").asList()) {
            result.add(connector.asString());
        }
        return result;
    }
}

