/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.EnumSet;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.messaging.AcceptorControlHandler;
import org.jboss.as.messaging.AddressControlHandler;
import org.jboss.as.messaging.AddressSettingAdd;
import org.jboss.as.messaging.AddressSettingRemove;
import org.jboss.as.messaging.AddressSettingsWriteHandler;
import org.jboss.as.messaging.BridgeAdd;
import org.jboss.as.messaging.BridgeControlHandler;
import org.jboss.as.messaging.BridgeRemove;
import org.jboss.as.messaging.BridgeWriteAttributeHandler;
import org.jboss.as.messaging.BroadcastGroupAdd;
import org.jboss.as.messaging.BroadcastGroupControlHandler;
import org.jboss.as.messaging.BroadcastGroupRemove;
import org.jboss.as.messaging.BroadcastGroupWriteAttributeHandler;
import org.jboss.as.messaging.ClusterConnectionAdd;
import org.jboss.as.messaging.ClusterConnectionControlHandler;
import org.jboss.as.messaging.ClusterConnectionRemove;
import org.jboss.as.messaging.ClusterConnectionWriteAttributeHandler;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.ConnectorServiceAdd;
import org.jboss.as.messaging.ConnectorServiceParamAdd;
import org.jboss.as.messaging.ConnectorServiceParamRemove;
import org.jboss.as.messaging.ConnectorServiceParamWriteAttributeHandler;
import org.jboss.as.messaging.ConnectorServiceRemove;
import org.jboss.as.messaging.ConnectorServiceWriteAttributeHandler;
import org.jboss.as.messaging.DiscoveryGroupAdd;
import org.jboss.as.messaging.DiscoveryGroupRemove;
import org.jboss.as.messaging.DiscoveryGroupWriteAttributeHandler;
import org.jboss.as.messaging.DivertAdd;
import org.jboss.as.messaging.DivertConfigurationWriteHandler;
import org.jboss.as.messaging.DivertRemove;
import org.jboss.as.messaging.GroupingHandlerAdd;
import org.jboss.as.messaging.GroupingHandlerRemove;
import org.jboss.as.messaging.GroupingHandlerWriteAttributeHandler;
import org.jboss.as.messaging.HornetQServerResourceDefinition;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingPathHandlers;
import org.jboss.as.messaging.MessagingSubsystemDescribeHandler;
import org.jboss.as.messaging.MessagingSubsystemParser;
import org.jboss.as.messaging.MessagingSubsystemProviders;
import org.jboss.as.messaging.MessagingSubsystemRootResourceDefinition;
import org.jboss.as.messaging.Namespace;
import org.jboss.as.messaging.QueueAdd;
import org.jboss.as.messaging.QueueConfigurationWriteHandler;
import org.jboss.as.messaging.QueueControlHandler;
import org.jboss.as.messaging.QueueReadAttributeHandler;
import org.jboss.as.messaging.QueueRemove;
import org.jboss.as.messaging.SecurityRoleAdd;
import org.jboss.as.messaging.SecurityRoleAttributeHandler;
import org.jboss.as.messaging.SecurityRoleRemove;
import org.jboss.as.messaging.SecuritySettingAdd;
import org.jboss.as.messaging.SecuritySettingRemove;
import org.jboss.as.messaging.TransportConfigOperationHandlers;
import org.jboss.as.messaging.jms.ConnectionFactoryAdd;
import org.jboss.as.messaging.jms.ConnectionFactoryAddJndiHandler;
import org.jboss.as.messaging.jms.ConnectionFactoryReadAttributeHandler;
import org.jboss.as.messaging.jms.ConnectionFactoryRemove;
import org.jboss.as.messaging.jms.ConnectionFactoryWriteAttributeHandler;
import org.jboss.as.messaging.jms.JMSQueueAdd;
import org.jboss.as.messaging.jms.JMSQueueAddJndiHandler;
import org.jboss.as.messaging.jms.JMSQueueConfigurationRuntimeHandler;
import org.jboss.as.messaging.jms.JMSQueueConfigurationWriteHandler;
import org.jboss.as.messaging.jms.JMSQueueControlHandler;
import org.jboss.as.messaging.jms.JMSQueueReadAttributeHandler;
import org.jboss.as.messaging.jms.JMSQueueRemove;
import org.jboss.as.messaging.jms.JMSTopicAdd;
import org.jboss.as.messaging.jms.JMSTopicAddJndiHandler;
import org.jboss.as.messaging.jms.JMSTopicConfigurationRuntimeHandler;
import org.jboss.as.messaging.jms.JMSTopicConfigurationWriteHandler;
import org.jboss.as.messaging.jms.JMSTopicControlHandler;
import org.jboss.as.messaging.jms.JMSTopicReadAttributeHandler;
import org.jboss.as.messaging.jms.JMSTopicRemove;
import org.jboss.as.messaging.jms.PooledConnectionFactoryAdd;
import org.jboss.as.messaging.jms.PooledConnectionFactoryRemove;
import org.jboss.as.messaging.jms.PooledConnectionFactoryWriteAttributeHandler;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class MessagingExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "messaging";
    private static final String RESOURCE_NAME = MessagingDescriptions.class.getPackage().getName() + ".LocalDescriptions";
    static final PathElement ADDRESS_SETTING = PathElement.pathElement((String)"address-setting");
    static final PathElement GENERIC_ACCEPTOR = PathElement.pathElement((String)"acceptor");
    static final PathElement REMOTE_ACCEPTOR = PathElement.pathElement((String)"remote-acceptor");
    static final PathElement IN_VM_ACCEPTOR = PathElement.pathElement((String)"in-vm-acceptor");
    static final PathElement GENERIC_CONNECTOR = PathElement.pathElement((String)"connector");
    static final PathElement REMOTE_CONNECTOR = PathElement.pathElement((String)"remote-connector");
    static final PathElement IN_VM_CONNECTOR = PathElement.pathElement((String)"in-vm-connector");
    static final PathElement PARAM = PathElement.pathElement((String)"param");
    private static final PathElement CORE_ADDRESS_PATH = PathElement.pathElement((String)"core-address");
    private static final PathElement CFS_PATH = PathElement.pathElement((String)"connection-factory");
    private static final PathElement JMS_QUEUE_PATH = PathElement.pathElement((String)"jms-queue");
    private static final PathElement TOPIC_PATH = PathElement.pathElement((String)"jms-topic");
    private static final PathElement RA_PATH = PathElement.pathElement((String)"pooled-connection-factory");
    private static final PathElement BROADCAST_GROUP_PATH = PathElement.pathElement((String)"broadcast-group");
    private static final PathElement DISCOVERY_GROUP_PATH = PathElement.pathElement((String)"discovery-group");
    private static final PathElement DIVERT_PATH = PathElement.pathElement((String)"divert");
    private static final PathElement GROUPING_HANDLER_PATH = PathElement.pathElement((String)"grouping-handler");
    static final PathElement SECURITY_ROLE = PathElement.pathElement((String)"role");
    static final PathElement SECURITY_SETTING = PathElement.pathElement((String)"security-setting");

    static ResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return new StandardResourceDescriptionResolver(keyPrefix, RESOURCE_NAME, MessagingExtension.class.getClassLoader(), true, true);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 0);
        subsystem.registerXMLElementWriter((XMLElementWriter)MessagingSubsystemParser.getInstance());
        boolean registerRuntimeOnly = context.isRuntimeOnlyRegistrationValid();
        ManagementResourceRegistration rootRegistration = subsystem.registerSubsystemModel((ResourceDefinition)MessagingSubsystemRootResourceDefinition.INSTANCE);
        rootRegistration.registerOperationHandler("describe", (OperationStepHandler)MessagingSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)MessagingSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        ManagementResourceRegistration serverRegistration = rootRegistration.registerSubModel((ResourceDefinition)new HornetQServerResourceDefinition(registerRuntimeOnly));
        if (registerRuntimeOnly) {
            ManagementResourceRegistration coreAddress = serverRegistration.registerSubModel(CORE_ADDRESS_PATH, MessagingSubsystemProviders.CORE_ADDRESS);
            coreAddress.setRuntimeOnly(true);
            AddressControlHandler.INSTANCE.register(coreAddress);
        }
        ManagementResourceRegistration addressSetting = serverRegistration.registerSubModel(ADDRESS_SETTING, MessagingSubsystemProviders.ADDRESS_SETTING);
        addressSetting.registerOperationHandler("add", AddressSettingAdd.INSTANCE, MessagingSubsystemProviders.ADDRESS_SETTING_ADD);
        addressSetting.registerOperationHandler("remove", AddressSettingRemove.INSTANCE, MessagingSubsystemProviders.ADDRESS_SETTING_REMOVE);
        AddressSettingsWriteHandler.INSTANCE.registerAttributes(addressSetting, registerRuntimeOnly);
        ManagementResourceRegistration broadcastGroups = serverRegistration.registerSubModel(BROADCAST_GROUP_PATH, MessagingSubsystemProviders.BROADCAST_GROUP_RESOURCE);
        broadcastGroups.registerOperationHandler("add", (OperationStepHandler)BroadcastGroupAdd.INSTANCE, (DescriptionProvider)BroadcastGroupAdd.INSTANCE);
        broadcastGroups.registerOperationHandler("remove", (OperationStepHandler)BroadcastGroupRemove.INSTANCE, (DescriptionProvider)BroadcastGroupRemove.INSTANCE);
        BroadcastGroupWriteAttributeHandler.INSTANCE.registerAttributes(broadcastGroups, registerRuntimeOnly);
        if (registerRuntimeOnly) {
            BroadcastGroupControlHandler.INSTANCE.register(broadcastGroups);
        }
        ManagementResourceRegistration discoveryGroups = serverRegistration.registerSubModel(DISCOVERY_GROUP_PATH, MessagingSubsystemProviders.DISCOVERY_GROUP_RESOURCE);
        discoveryGroups.registerOperationHandler("add", (OperationStepHandler)DiscoveryGroupAdd.INSTANCE, (DescriptionProvider)DiscoveryGroupAdd.INSTANCE);
        discoveryGroups.registerOperationHandler("remove", (OperationStepHandler)DiscoveryGroupRemove.INSTANCE, (DescriptionProvider)DiscoveryGroupRemove.INSTANCE);
        DiscoveryGroupWriteAttributeHandler.INSTANCE.registerAttributes(discoveryGroups, registerRuntimeOnly);
        ManagementResourceRegistration diverts = serverRegistration.registerSubModel(DIVERT_PATH, MessagingSubsystemProviders.DIVERT_RESOURCE);
        diverts.registerOperationHandler("add", (OperationStepHandler)DivertAdd.INSTANCE, (DescriptionProvider)DivertAdd.INSTANCE);
        diverts.registerOperationHandler("remove", (OperationStepHandler)DivertRemove.INSTANCE, (DescriptionProvider)DivertRemove.INSTANCE);
        DivertConfigurationWriteHandler.INSTANCE.registerAttributes(diverts, registerRuntimeOnly);
        ManagementResourceRegistration queue = serverRegistration.registerSubModel(PathElement.pathElement((String)"queue"), MessagingSubsystemProviders.QUEUE_RESOURCE);
        queue.registerOperationHandler("add", (OperationStepHandler)QueueAdd.INSTANCE, (DescriptionProvider)QueueAdd.INSTANCE, false);
        queue.registerOperationHandler("remove", (OperationStepHandler)QueueRemove.INSTANCE, (DescriptionProvider)QueueRemove.INSTANCE, false);
        QueueConfigurationWriteHandler.INSTANCE.registerAttributes(queue, registerRuntimeOnly);
        if (registerRuntimeOnly) {
            QueueReadAttributeHandler.INSTANCE.registerAttributes(queue);
            QueueControlHandler.INSTANCE.registerOperations(queue);
        }
        ManagementResourceRegistration acceptor = serverRegistration.registerSubModel(GENERIC_ACCEPTOR, MessagingSubsystemProviders.ACCEPTOR);
        acceptor.registerOperationHandler("add", TransportConfigOperationHandlers.GENERIC_ADD, MessagingSubsystemProviders.ACCEPTOR_ADD);
        acceptor.registerOperationHandler("remove", TransportConfigOperationHandlers.REMOVE, MessagingSubsystemProviders.ACCEPTOR_REMOVE);
        TransportConfigOperationHandlers.GENERIC_ATTR.registerAttributes(acceptor, registerRuntimeOnly);
        MessagingExtension.createParamRegistration(acceptor);
        if (registerRuntimeOnly) {
            AcceptorControlHandler.INSTANCE.register(acceptor);
        }
        ManagementResourceRegistration remoteAcceptor = serverRegistration.registerSubModel(REMOTE_ACCEPTOR, MessagingSubsystemProviders.REMOTE_ACCEPTOR);
        remoteAcceptor.registerOperationHandler("add", TransportConfigOperationHandlers.REMOTE_ADD, MessagingSubsystemProviders.REMOTE_ACCEPTOR_ADD);
        remoteAcceptor.registerOperationHandler("remove", TransportConfigOperationHandlers.REMOVE, MessagingSubsystemProviders.ACCEPTOR_REMOVE);
        TransportConfigOperationHandlers.REMOTE_ATTR.registerAttributes(remoteAcceptor, registerRuntimeOnly);
        MessagingExtension.createParamRegistration(remoteAcceptor);
        if (registerRuntimeOnly) {
            AcceptorControlHandler.INSTANCE.register(remoteAcceptor);
        }
        ManagementResourceRegistration inVMAcceptor = serverRegistration.registerSubModel(IN_VM_ACCEPTOR, MessagingSubsystemProviders.IN_VM_ACCEPTOR);
        inVMAcceptor.registerOperationHandler("add", TransportConfigOperationHandlers.IN_VM_ADD, MessagingSubsystemProviders.IN_VM_ACCEPTOR_ADD);
        inVMAcceptor.registerOperationHandler("remove", TransportConfigOperationHandlers.REMOVE, MessagingSubsystemProviders.ACCEPTOR_REMOVE);
        TransportConfigOperationHandlers.IN_VM_ATTR.registerAttributes(inVMAcceptor, registerRuntimeOnly);
        MessagingExtension.createParamRegistration(inVMAcceptor);
        if (registerRuntimeOnly) {
            AcceptorControlHandler.INSTANCE.register(inVMAcceptor);
        }
        ManagementResourceRegistration connector = serverRegistration.registerSubModel(GENERIC_CONNECTOR, MessagingSubsystemProviders.CONNECTOR);
        connector.registerOperationHandler("add", TransportConfigOperationHandlers.GENERIC_ADD, MessagingSubsystemProviders.CONNECTOR_ADD);
        connector.registerOperationHandler("remove", TransportConfigOperationHandlers.REMOVE, MessagingSubsystemProviders.CONNECTOR_REMOVE);
        TransportConfigOperationHandlers.GENERIC_ATTR.registerAttributes(connector, registerRuntimeOnly);
        MessagingExtension.createParamRegistration(connector);
        ManagementResourceRegistration remoteConnector = serverRegistration.registerSubModel(REMOTE_CONNECTOR, MessagingSubsystemProviders.REMOTE_CONNECTOR);
        remoteConnector.registerOperationHandler("add", TransportConfigOperationHandlers.REMOTE_ADD, MessagingSubsystemProviders.REMOTE_CONNECTOR_ADD);
        remoteConnector.registerOperationHandler("remove", TransportConfigOperationHandlers.REMOVE, MessagingSubsystemProviders.CONNECTOR_REMOVE);
        TransportConfigOperationHandlers.REMOTE_ATTR.registerAttributes(remoteConnector, registerRuntimeOnly);
        MessagingExtension.createParamRegistration(remoteConnector);
        ManagementResourceRegistration inVMConnector = serverRegistration.registerSubModel(IN_VM_CONNECTOR, MessagingSubsystemProviders.IN_VM_CONNECTOR);
        inVMConnector.registerOperationHandler("add", TransportConfigOperationHandlers.IN_VM_ADD, MessagingSubsystemProviders.IN_VM_CONNECTOR_ADD);
        inVMConnector.registerOperationHandler("remove", TransportConfigOperationHandlers.REMOVE, MessagingSubsystemProviders.CONNECTOR_REMOVE);
        TransportConfigOperationHandlers.IN_VM_ATTR.registerAttributes(inVMConnector, registerRuntimeOnly);
        MessagingExtension.createParamRegistration(inVMConnector);
        ManagementResourceRegistration bridge = serverRegistration.registerSubModel(PathElement.pathElement((String)"bridge"), MessagingSubsystemProviders.BRIDGE_RESOURCE);
        bridge.registerOperationHandler("add", (OperationStepHandler)BridgeAdd.INSTANCE, (DescriptionProvider)BridgeAdd.INSTANCE, false);
        bridge.registerOperationHandler("remove", (OperationStepHandler)BridgeRemove.INSTANCE, (DescriptionProvider)BridgeRemove.INSTANCE, false);
        BridgeWriteAttributeHandler.INSTANCE.registerAttributes(bridge, registerRuntimeOnly);
        if (registerRuntimeOnly) {
            BridgeControlHandler.INSTANCE.register(bridge);
        }
        ManagementResourceRegistration cluster = serverRegistration.registerSubModel(PathElement.pathElement((String)"cluster-connection"), MessagingSubsystemProviders.CLUSTER_CONNECTION_RESOURCE);
        cluster.registerOperationHandler("add", (OperationStepHandler)ClusterConnectionAdd.INSTANCE, (DescriptionProvider)ClusterConnectionAdd.INSTANCE, false);
        cluster.registerOperationHandler("remove", (OperationStepHandler)ClusterConnectionRemove.INSTANCE, (DescriptionProvider)ClusterConnectionRemove.INSTANCE, false);
        ClusterConnectionWriteAttributeHandler.INSTANCE.registerAttributes(cluster, registerRuntimeOnly);
        if (registerRuntimeOnly) {
            ClusterConnectionControlHandler.INSTANCE.register(cluster);
        }
        ManagementResourceRegistration groupingHandler = serverRegistration.registerSubModel(GROUPING_HANDLER_PATH, MessagingSubsystemProviders.GROUPING_HANDLER_RESOURCE);
        groupingHandler.registerOperationHandler("add", (OperationStepHandler)GroupingHandlerAdd.INSTANCE, (DescriptionProvider)GroupingHandlerAdd.INSTANCE);
        groupingHandler.registerOperationHandler("remove", (OperationStepHandler)GroupingHandlerRemove.INSTANCE, (DescriptionProvider)GroupingHandlerRemove.INSTANCE);
        GroupingHandlerWriteAttributeHandler.INSTANCE.registerAttributes(groupingHandler, registerRuntimeOnly);
        ManagementResourceRegistration connectorService = serverRegistration.registerSubModel(PathElement.pathElement((String)"connector-service"), MessagingSubsystemProviders.CONNECTOR_SERVICE_RESOURCE);
        connectorService.registerOperationHandler("add", (OperationStepHandler)ConnectorServiceAdd.INSTANCE, (DescriptionProvider)ConnectorServiceAdd.INSTANCE, false);
        connectorService.registerOperationHandler("remove", (OperationStepHandler)ConnectorServiceRemove.INSTANCE, (DescriptionProvider)ConnectorServiceRemove.INSTANCE, false);
        ConnectorServiceWriteAttributeHandler.INSTANCE.registerAttributes(connectorService, registerRuntimeOnly);
        ManagementResourceRegistration connectorServiceParam = connectorService.registerSubModel(PathElement.pathElement((String)"param"), MessagingSubsystemProviders.CONNECTOR_SERVICE_PARAM_RESOURCE);
        connectorServiceParam.registerOperationHandler("add", (OperationStepHandler)ConnectorServiceParamAdd.INSTANCE, (DescriptionProvider)ConnectorServiceParamAdd.INSTANCE, false);
        connectorServiceParam.registerOperationHandler("remove", (OperationStepHandler)ConnectorServiceParamRemove.INSTANCE, (DescriptionProvider)ConnectorServiceParamRemove.INSTANCE, false);
        connectorServiceParam.registerReadWriteAttribute(CommonAttributes.VALUE.getName(), null, (OperationStepHandler)ConnectorServiceParamWriteAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        for (String path : CommonAttributes.PATHS) {
            ManagementResourceRegistration bindings = serverRegistration.registerSubModel(PathElement.pathElement((String)"path", (String)path), (DescriptionProvider)new MessagingSubsystemProviders.PathProvider(path));
            MessagingPathHandlers.register(bindings);
        }
        ManagementResourceRegistration cfs = serverRegistration.registerSubModel(CFS_PATH, MessagingSubsystemProviders.CF);
        cfs.registerOperationHandler("add", (OperationStepHandler)ConnectionFactoryAdd.INSTANCE, MessagingSubsystemProviders.CF_ADD, false);
        cfs.registerOperationHandler("remove", (OperationStepHandler)ConnectionFactoryRemove.INSTANCE, MessagingSubsystemProviders.CF_REMOVE, false);
        ConnectionFactoryWriteAttributeHandler.INSTANCE.registerAttributes(cfs);
        if (registerRuntimeOnly) {
            ConnectionFactoryReadAttributeHandler.INSTANCE.registerAttributes(cfs);
        }
        ConnectionFactoryAddJndiHandler.INSTANCE.registerOperation(cfs);
        ManagementResourceRegistration resourceAdapters = serverRegistration.registerSubModel(RA_PATH, MessagingSubsystemProviders.RA);
        resourceAdapters.registerOperationHandler("add", (OperationStepHandler)PooledConnectionFactoryAdd.INSTANCE, MessagingSubsystemProviders.RA_ADD, false);
        resourceAdapters.registerOperationHandler("remove", (OperationStepHandler)PooledConnectionFactoryRemove.INSTANCE, MessagingSubsystemProviders.RA_REMOVE);
        PooledConnectionFactoryWriteAttributeHandler.INSTANCE.registerAttributes(resourceAdapters, registerRuntimeOnly);
        ManagementResourceRegistration queues = serverRegistration.registerSubModel(JMS_QUEUE_PATH, MessagingSubsystemProviders.JMS_QUEUE_RESOURCE);
        queues.registerOperationHandler("add", (OperationStepHandler)JMSQueueAdd.INSTANCE, (DescriptionProvider)JMSQueueAdd.INSTANCE, false);
        queues.registerOperationHandler("remove", (OperationStepHandler)JMSQueueRemove.INSTANCE, (DescriptionProvider)JMSQueueRemove.INSTANCE, false);
        JMSQueueConfigurationWriteHandler.INSTANCE.registerAttributes(queues, registerRuntimeOnly);
        JMSQueueAddJndiHandler.INSTANCE.registerOperation(queues);
        if (registerRuntimeOnly) {
            JMSQueueReadAttributeHandler.INSTANCE.registerAttributes(queues);
            JMSQueueControlHandler.INSTANCE.registerOperations(queues);
        }
        ManagementResourceRegistration topics = serverRegistration.registerSubModel(TOPIC_PATH, MessagingSubsystemProviders.JMS_TOPIC_RESOURCE);
        topics.registerOperationHandler("add", (OperationStepHandler)JMSTopicAdd.INSTANCE, (DescriptionProvider)JMSTopicAdd.INSTANCE, false);
        topics.registerOperationHandler("remove", (OperationStepHandler)JMSTopicRemove.INSTANCE, (DescriptionProvider)JMSTopicRemove.INSTANCE, false);
        JMSTopicConfigurationWriteHandler.INSTANCE.registerAttributes(topics);
        JMSTopicAddJndiHandler.INSTANCE.registerOperation(topics);
        if (registerRuntimeOnly) {
            JMSTopicReadAttributeHandler.INSTANCE.registerAttributes(topics);
            JMSTopicControlHandler.INSTANCE.registerOperations(topics);
        }
        ManagementResourceRegistration securitySettings = serverRegistration.registerSubModel(SECURITY_SETTING, MessagingSubsystemProviders.SECURITY_SETTING);
        securitySettings.registerOperationHandler("add", (OperationStepHandler)SecuritySettingAdd.INSTANCE, (DescriptionProvider)SecuritySettingAdd.INSTANCE);
        securitySettings.registerOperationHandler("remove", (OperationStepHandler)SecuritySettingRemove.INSTANCE, (DescriptionProvider)SecuritySettingRemove.INSTANCE);
        ManagementResourceRegistration securityRole = securitySettings.registerSubModel(SECURITY_ROLE, MessagingSubsystemProviders.SECURITY_ROLE);
        securityRole.registerOperationHandler("add", (OperationStepHandler)SecurityRoleAdd.INSTANCE, (DescriptionProvider)SecurityRoleAdd.INSTANCE);
        securityRole.registerOperationHandler("remove", (OperationStepHandler)SecurityRoleRemove.INSTANCE, (DescriptionProvider)SecurityRoleRemove.INSTANCE);
        SecurityRoleAttributeHandler.INSTANCE.registerAttributes(securityRole, registerRuntimeOnly);
        if (context.isRuntimeOnlyRegistrationValid()) {
            SimpleResourceDefinition deploymentsDef = new SimpleResourceDefinition(PathElement.pathElement((String)"subsystem", (String)SUBSYSTEM_NAME), MessagingExtension.getResourceDescriptionResolver("deployed"));
            ManagementResourceRegistration deploymentsRegistration = subsystem.registerDeploymentModel((ResourceDefinition)deploymentsDef);
            ManagementResourceRegistration serverModel = deploymentsRegistration.registerSubModel((ResourceDefinition)new HornetQServerResourceDefinition(true));
            ManagementResourceRegistration deploymentQueue = serverModel.registerSubModel(JMS_QUEUE_PATH, MessagingSubsystemProviders.JMS_QUEUE_RESOURCE);
            JMSQueueReadAttributeHandler.INSTANCE.registerAttributes(deploymentQueue);
            JMSQueueControlHandler.INSTANCE.registerOperations(deploymentQueue);
            JMSQueueConfigurationRuntimeHandler.INSTANCE.registerAttributes(deploymentQueue);
            ManagementResourceRegistration deploymentTopics = serverModel.registerSubModel(TOPIC_PATH, MessagingSubsystemProviders.JMS_TOPIC_RESOURCE);
            JMSTopicReadAttributeHandler.INSTANCE.registerAttributes(deploymentTopics);
            JMSTopicControlHandler.INSTANCE.registerOperations(deploymentTopics);
            JMSTopicConfigurationRuntimeHandler.INSTANCE.registerAttributes(deploymentTopics);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (Namespace namespace : Namespace.values()) {
            if (namespace == Namespace.UNKNOWN) continue;
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, namespace.getUriString(), (XMLElementReader)MessagingSubsystemParser.getInstance());
        }
    }

    static void createParamRegistration(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel(PARAM, MessagingSubsystemProviders.PARAM);
        registration.registerOperationHandler("add", TransportConfigOperationHandlers.PARAM_ADD, MessagingSubsystemProviders.PARAM_ADD);
        registration.registerOperationHandler("remove", TransportConfigOperationHandlers.REMOVE, MessagingSubsystemProviders.PARAM_REMOVE);
        registration.registerReadWriteAttribute("value", null, TransportConfigOperationHandlers.PARAM_ATTR, EnumSet.of(AttributeAccess.Flag.RESTART_ALL_SERVICES));
    }
}

