/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.hornetq.api.jms.management.ConnectionFactoryControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class ConnectionFactoryWriteAttributeHandler
extends AbstractWriteAttributeHandler<Void> {
    public static final ConnectionFactoryWriteAttributeHandler INSTANCE = new ConnectionFactoryWriteAttributeHandler();
    private static final EnumSet<AttributeAccess.Flag> RESTART_NONE = EnumSet.of(AttributeAccess.Flag.RESTART_NONE);
    private static final EnumSet<AttributeAccess.Flag> RESTART_ALL = EnumSet.of(AttributeAccess.Flag.RESTART_ALL_SERVICES);
    private final Map<String, AttributeDefinition> runtimeAttributes = new HashMap<String, AttributeDefinition>();

    private ConnectionFactoryWriteAttributeHandler() {
        super(JMSServices.CONNECTION_FACTORY_ATTRS);
        for (AttributeDefinition attr : JMSServices.CONNECTION_FACTORY_WRITE_ATTRS) {
            this.runtimeAttributes.put(attr.getName(), attr);
        }
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        for (AttributeDefinition attr : JMSServices.CONNECTION_FACTORY_ATTRS) {
            String attrName = attr.getName();
            EnumSet<AttributeAccess.Flag> flags = this.runtimeAttributes.containsKey(attrName) ? RESTART_NONE : RESTART_ALL;
            registry.registerReadWriteAttribute(attrName, null, (OperationStepHandler)this, flags);
        }
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ServiceName hqServiceName;
        AttributeDefinition attr = this.runtimeAttributes.get(attributeName);
        if (attr == null) {
            return true;
        }
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController hqService = registry.getService(hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (hqService == null) {
            return false;
        }
        if (hqService.getState() != ServiceController.State.UP) {
            return true;
        }
        this.applyOperationToHornetQService(context, this.getName(operation), attributeName, newValue, hqService);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ServiceName hqServiceName;
        ServiceRegistry registry;
        ServiceController hqService;
        if (this.runtimeAttributes.containsKey(attributeName) && (hqService = (registry = context.getServiceRegistry(true)).getService(hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))))) != null && hqService.getState() == ServiceController.State.UP) {
            this.applyOperationToHornetQService(context, this.getName(operation), attributeName, valueToRestore, hqService);
        }
    }

    private String getName(ModelNode operation) {
        return PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
    }

    private void applyOperationToHornetQService(OperationContext context, String name, String attributeName, ModelNode value, ServiceController<?> hqService) {
        block32: {
            HornetQServer server = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
            ConnectionFactoryControl control = (ConnectionFactoryControl)ConnectionFactoryControl.class.cast(server.getManagementService().getResource("jms.connectionfactory." + name));
            try {
                if (attributeName.equals(CommonAttributes.CLIENT_ID.getName())) {
                    control.setClientID(value.isDefined() ? value.asString() : null);
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.COMPRESS_LARGE_MESSAGES.getName())) {
                    control.setCompressLargeMessages(value.asBoolean());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CLIENT_FAILURE_CHECK_PERIOD.getName())) {
                    control.setClientFailureCheckPeriod(value.asLong());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CALL_TIMEOUT.getName())) {
                    control.setCallTimeout(value.asLong());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.DUPS_OK_BATCH_SIZE.getName())) {
                    control.setDupsOKBatchSize(value.asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CONSUMER_MAX_RATE.getName())) {
                    control.setConsumerMaxRate(value.asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CONSUMER_WINDOW_SIZE.getName())) {
                    control.setConsumerWindowSize(value.asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.PRODUCER_MAX_RATE.getName())) {
                    control.setProducerMaxRate(value.asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CONFIRMATION_WINDOW_SIZE.getName())) {
                    control.setConfirmationWindowSize(value.asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.BLOCK_ON_ACK.getName())) {
                    control.setBlockOnAcknowledge(value.asBoolean());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.BLOCK_ON_DURABLE_SEND.getName())) {
                    control.setBlockOnDurableSend(value.asBoolean());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.BLOCK_ON_NON_DURABLE_SEND.getName())) {
                    control.setBlockOnNonDurableSend(value.asBoolean());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.PRE_ACK.getName())) {
                    control.setPreAcknowledge(value.asBoolean());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CONNECTION_TTL.getName())) {
                    control.setConnectionTTL(value.asLong());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.TRANSACTION_BATCH_SIZE.getName())) {
                    control.setTransactionBatchSize(value.asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.MIN_LARGE_MESSAGE_SIZE.getName())) {
                    control.setMinLargeMessageSize(value.asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.AUTO_GROUP.getName())) {
                    control.setAutoGroup(value.asBoolean());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.RETRY_INTERVAL.getName())) {
                    control.setRetryInterval(value.asLong());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.RETRY_INTERVAL_MULTIPLIER.getName())) {
                    control.setRetryIntervalMultiplier(value.asDouble());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CONNECTION_FACTORY_RECONNECT_ATTEMPTS.getName())) {
                    control.setReconnectAttempts(value.asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.FAILOVER_ON_INITIAL_CONNECTION.getName())) {
                    control.setFailoverOnInitialConnection(value.asBoolean());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.PRODUCER_WINDOW_SIZE.getName())) {
                    control.setProducerWindowSize(value.asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CACHE_LARGE_MESSAGE_CLIENT.getName())) {
                    control.setCacheLargeMessagesClient(value.asBoolean());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.MAX_RETRY_INTERVAL.getName())) {
                    control.setMaxRetryInterval(value.asLong());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CONNECTION_SCHEDULED_THREAD_POOL_MAX_SIZE.getName())) {
                    control.setScheduledThreadPoolMaxSize(value.asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CONNECTION_THREAD_POOL_MAX_SIZE.getName())) {
                    control.setThreadPoolMaxSize(value.asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.GROUP_ID.getName())) {
                    control.setGroupID(value.isDefined() ? value.asString() : null);
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.USE_GLOBAL_POOLS.getName())) {
                    control.setUseGlobalPools(value.asBoolean());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.LOAD_BALANCING_CLASS_NAME.getName())) {
                    control.setConnectionLoadBalancingPolicyClassName(value.asString());
                    break block32;
                }
                throw MessagingMessages.MESSAGES.unsupportedRuntimeAttribute(attributeName);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

