/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.concurrent.Executor;
import org.hornetq.jms.server.JMSServerManager;
import org.jboss.as.messaging.MessagingLogger;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class JMSTopicService
implements Service<Void> {
    private final InjectedValue<JMSServerManager> jmsServer = new InjectedValue();
    private final InjectedValue<Executor> executorInjector = new InjectedValue();
    private final String name;
    private final String[] jndi;

    public JMSTopicService(String name, String[] jndi) {
        this.name = name;
        this.jndi = jndi;
    }

    public synchronized void start(final StartContext context) throws StartException {
        final JMSServerManager jmsManager = (JMSServerManager)this.jmsServer.getValue();
        context.asynchronous();
        ((Executor)this.executorInjector.getValue()).execute(new Runnable(){

            @Override
            public void run() {
                try {
                    jmsManager.createTopic(false, JMSTopicService.this.name, JMSTopicService.this.jndi);
                    context.complete();
                }
                catch (Throwable e) {
                    context.failed(MessagingMessages.MESSAGES.failedToCreate(e, "queue"));
                }
            }
        });
    }

    public synchronized void stop(final StopContext context) {
        final JMSServerManager jmsManager = (JMSServerManager)this.jmsServer.getValue();
        context.asynchronous();
        ((Executor)this.executorInjector.getValue()).execute(new Runnable(){

            @Override
            public void run() {
                try {
                    jmsManager.removeTopicFromJNDI(JMSTopicService.this.name);
                }
                catch (Throwable e) {
                    MessagingLogger.MESSAGING_LOGGER.failedToDestroy(e, "jms topic", JMSTopicService.this.name);
                }
                context.complete();
            }
        });
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }

    public InjectedValue<JMSServerManager> getJmsServer() {
        return this.jmsServer;
    }

    public InjectedValue<Executor> getExecutorInjector() {
        return this.executorInjector;
    }
}

